"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRelatedDashboards = exports.getRelatedDashboardsQueryKey = exports.fetchRelatedDashboards = void 0;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchRelatedDashboards = async ({
  alertId,
  http
}) => {
  return http.get(_constants.ALERTS_API_URLS.INTERNAL_RELATED_DASHBOARDS, {
    query: {
      alertId
    }
  });
};
exports.fetchRelatedDashboards = fetchRelatedDashboards;
const getDashboardMetadata = ({
  description,
  id,
  title
}) => ({
  description,
  id,
  title
});
const getRelatedDashboardsQueryKey = alertId => ['relatedDashboards', alertId];
exports.getRelatedDashboardsQueryKey = getRelatedDashboardsQueryKey;
const useRelatedDashboards = alertId => {
  var _data$suggestedDashbo, _data$linkedDashboard;
  const {
    http
  } = (0, _public.useKibana)().services;
  const {
    data,
    isLoading,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: getRelatedDashboardsQueryKey(alertId),
    queryFn: () => fetchRelatedDashboards({
      alertId,
      http
    }),
    refetchOnWindowFocus: false // Disable window focus refetching
  });
  return {
    isLoadingRelatedDashboards: isLoading,
    suggestedDashboards: data === null || data === void 0 ? void 0 : (_data$suggestedDashbo = data.suggestedDashboards) === null || _data$suggestedDashbo === void 0 ? void 0 : _data$suggestedDashbo.map(getDashboardMetadata),
    linkedDashboards: data === null || data === void 0 ? void 0 : (_data$linkedDashboard = data.linkedDashboards) === null || _data$linkedDashboard === void 0 ? void 0 : _data$linkedDashboard.map(getDashboardMetadata),
    refetchRelatedDashboards: refetch
  };
};
exports.useRelatedDashboards = useRelatedDashboards;