"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigationGuide = InvestigationGuide;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("@kbn/response-ops-rule-form/src/constants");
var _react2 = _interopRequireWildcard(require("react"));
var _AlertDetailsRuleFormFlyout = require("./AlertDetailsRuleFormFlyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InvestigationGuide({
  blob,
  onUpdate,
  refetch,
  rule
}) {
  const [alertDetailsRuleFormFlyoutOpen, setAlertDetailsRuleFormFlyoutOpen] = (0, _react2.useState)(false);
  return blob ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiMarkdownFormat, {
    css: (0, _react.css)`
          word-wrap: break-word;
        `
  }, blob)) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoObservability",
    iconColor: "default",
    title: /*#__PURE__*/_react2.default.createElement("h3", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alertDetails.investigationGide.emptyPrompt.title",
      defaultMessage: "Add an Investigation Guide"
    })),
    titleSize: "m",
    body: /*#__PURE__*/_react2.default.createElement("p", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alertDetails.investigationGide.emptyPrompt.body",
      defaultMessage: "Add a guide to your alert's rule."
    })),
    actions: /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      "data-test-subj": "xpack.observability.alertDetails.investigationGuide.emptyPrompt.addGuide",
      color: "primary",
      onClick: () => setAlertDetailsRuleFormFlyoutOpen(true),
      fill: true
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.alertDetails.investigationGide.emptyPrompt.addGuideButton.copy",
      defaultMessage: "Add guide"
    }))
  }), !!rule && /*#__PURE__*/_react2.default.createElement(_AlertDetailsRuleFormFlyout.AlertDetailsRuleFormFlyout, {
    initialEditStep: _constants.RuleFormStepId.DETAILS,
    isRuleFormFlyoutOpen: alertDetailsRuleFormFlyoutOpen,
    setIsRuleFormFlyoutOpen: setAlertDetailsRuleFormFlyoutOpen,
    onUpdate: onUpdate,
    refetch: refetch,
    rule: rule
  }));
}