"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeBuckets = void 0;
var _react = require("react");
var _common = require("@kbn/data-plugin/common");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimeBuckets = () => {
  const {
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  return (0, _react.useMemo)(() => {
    return new _common.TimeBuckets({
      'histogram:maxBars': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      'histogram:barTarget': uiSettings.get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
  }, [uiSettings]);
};
exports.useTimeBuckets = useTimeBuckets;