"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysis = LogRateAnalysis;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _log_rate_analysis_type = require("@kbn/aiops-log-rate-analysis/log_rate_analysis_type");
var _get_log_rate_analysis_parameters_from_alert = require("@kbn/aiops-log-rate-analysis/get_log_rate_analysis_parameters_from_alert");
var _public = require("@kbn/aiops-plugin/public");
var _dataService = require("@kbn/data-service");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _color_palette = require("../../../../../common/custom_threshold_rule/color_palette");
var _log_rate_analysis_query = require("./helpers/log_rate_analysis_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LogRateAnalysis({
  alert,
  dataView,
  services
}) {
  const {
    observabilityAIAssistant,
    uiSettings
  } = services;
  const ObservabilityAIAssistantContextualInsight = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.ObservabilityAIAssistantContextualInsight;
  const getContextualInsightMessages = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.getContextualInsightMessages;
  const [esSearchQuery, setEsSearchQuery] = (0, _react.useState)();
  const [logRateAnalysisParams, setLogRateAnalysisParams] = (0, _react.useState)();
  const ruleParams = alert.fields[_ruleDataUtils.ALERT_RULE_PARAMETERS];
  (0, _react.useEffect)(() => {
    const esSearchRequest = (0, _log_rate_analysis_query.getLogRateAnalysisEQQuery)(alert, (0, _dataService.getEsQueryConfig)(uiSettings));
    if (esSearchRequest) {
      setEsSearchQuery(esSearchRequest);
    }
  }, [alert, uiSettings]);
  const {
    timeRange,
    windowParameters
  } = (0, _react.useMemo)(() => {
    var _ruleParams$criteria$, _ruleParams$criteria$2;
    const alertStartedAt = (0, _moment.default)(alert.start).toISOString();
    const alertEndedAt = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).toISOString() : undefined;
    const timeSize = (_ruleParams$criteria$ = ruleParams.criteria[0]) === null || _ruleParams$criteria$ === void 0 ? void 0 : _ruleParams$criteria$.timeSize;
    const timeUnit = (_ruleParams$criteria$2 = ruleParams.criteria[0]) === null || _ruleParams$criteria$2 === void 0 ? void 0 : _ruleParams$criteria$2.timeUnit;
    return (0, _get_log_rate_analysis_parameters_from_alert.getLogRateAnalysisParametersFromAlert)({
      alertStartedAt,
      alertEndedAt,
      timeSize,
      timeUnit
    });
  }, [alert.fields, alert.start, ruleParams.criteria]);
  const logRateAnalysisTitle = _i18n.i18n.translate('xpack.observability.customThreshold.alertDetails.logRateAnalysisTitle', {
    defaultMessage: 'Possible causes and remediations'
  });
  const onAnalysisCompleted = analysisResults => {
    var _analysisResults$sign;
    const significantFieldValues = (0, _lodash.orderBy)(analysisResults === null || analysisResults === void 0 ? void 0 : (_analysisResults$sign = analysisResults.significantItems) === null || _analysisResults$sign === void 0 ? void 0 : _analysisResults$sign.map(item => ({
      field: item.fieldName,
      value: item.fieldValue,
      docCount: item.doc_count,
      pValue: item.pValue
    })), ['pValue', 'docCount'], ['asc', 'asc']).slice(0, 50);
    const logRateAnalysisType = analysisResults === null || analysisResults === void 0 ? void 0 : analysisResults.analysisType;
    setLogRateAnalysisParams(significantFieldValues && logRateAnalysisType ? {
      logRateAnalysisType,
      significantFieldValues
    } : undefined);
  };
  const messages = (0, _react.useMemo)(() => {
    var _logRateAnalysisParam;
    const hasLogRateAnalysisParams = logRateAnalysisParams && ((_logRateAnalysisParam = logRateAnalysisParams.significantFieldValues) === null || _logRateAnalysisParam === void 0 ? void 0 : _logRateAnalysisParam.length) > 0;
    if (!hasLogRateAnalysisParams) {
      return undefined;
    }
    const {
      logRateAnalysisType
    } = logRateAnalysisParams;
    const header = 'Field name,Field value,Doc count,p-value';
    const rows = logRateAnalysisParams.significantFieldValues.map(item => Object.values(item).join(',')).join('\n');
    const content = `You are an observability expert using Elastic Observability Suite on call being consulted about a log threshold alert that got triggered by a ${logRateAnalysisType} in log messages. Your job is to take immediate action and proceed with both urgency and precision.
      "Log Rate Analysis" is an AIOps feature that uses advanced statistical methods to identify reasons for increases and decreases in log rates. It makes it easy to find and investigate causes of unusual spikes or dips by using the analysis workflow view.
      You are using "Log Rate Analysis" and ran the statistical analysis on the log messages which occured during the alert.
      You received the following analysis results from "Log Rate Analysis" which list statistically significant co-occuring field/value combinations sorted from most significant (lower p-values) to least significant (higher p-values) that ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'contribute to the log rate spike' : 'are less or not present in the log rate dip'}:

      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'The median log rate in the selected deviation time range is higher than the baseline. Therefore, the results shows statistically significant items within the deviation time range that are contributors to the spike. The "doc count" column refers to the amount of documents in the deviation time range.' : 'The median log rate in the selected deviation time range is lower than the baseline. Therefore, the analysis results table shows statistically significant items within the baseline time range that are less in number or missing within the deviation time range. The "doc count" column refers to the amount of documents in the baseline time range.'}

      ${header}
      ${rows}

      Based on the above analysis results and your observability expert knowledge, output the following:
      Analyse the type of these logs and explain their usual purpose (1 paragraph).
      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'Based on the type of these logs do a root cause analysis on why the field and value combinations from the analysis results are causing this log rate spike (2 parapraphs)' : 'Based on the type of these logs explain why the statistically significant field and value combinations are less in number or missing from the log rate dip with concrete examples based on the analysis results data which contains items that are present in the baseline time range and are missing or less in number in the deviation time range (2 paragraphs)'}.
      ${logRateAnalysisType === _log_rate_analysis_type.LOG_RATE_ANALYSIS_TYPE.SPIKE ? 'Recommend concrete remediations to resolve the root cause (3 bullet points).' : ''}

      Do not mention individual p-values from the analysis results.
      Do not repeat the full list of field names and field values back to the user.
      Do not guess, just say what you are sure of. Do not repeat the given instructions in your output.`;
    return getContextualInsightMessages({
      message: 'Can you identify possible causes and remediations for these log rate analysis results',
      instructions: content
    });
  }, [logRateAnalysisParams, getContextualInsightMessages]);
  if (!dataView || !esSearchQuery) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "logRateAnalysisAlertDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.alertDetails.logRateAnalysis.sectionTitle",
    defaultMessage: "Log Rate Analysis"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.LogRateAnalysisContent, {
    dataView: dataView,
    timeRange: timeRange,
    esSearchQuery: esSearchQuery,
    initialAnalysisStart: windowParameters,
    barColorOverride: (0, _color_palette.colorTransformer)(_color_palette.Color.color0),
    barHighlightColorOverride: (0, _color_palette.colorTransformer)(_color_palette.Color.color1),
    onAnalysisCompleted: onAnalysisCompleted,
    appContextValue: {
      embeddingOrigin: 'observability_custom_threshold_alert_details',
      ...(0, _lodash.pick)(services, ['analytics', 'application', 'data', 'executionContext', 'charts', 'fieldFormats', 'http', 'notifications', 'share', 'storage', 'uiSettings', 'unifiedSearch', 'theme', 'userProfile', 'lens', 'i18n'])
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, ObservabilityAIAssistantContextualInsight && messages ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: logRateAnalysisTitle,
    messages: messages
  })) : null));
}