"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createShipperApiKey = createShipperApiKey;
var _privileges = require("./privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createShipperApiKey(esClient, name, withAPM = false) {
  // Based on https://www.elastic.co/guide/en/fleet/master/grant-access-to-elasticsearch.html#create-api-key-standalone-agent
  const timestamp = new Date().toISOString();
  return esClient.security.createApiKey({
    body: {
      name: `${name}-${timestamp}`,
      metadata: {
        managed: true,
        application: 'logs'
      },
      role_descriptors: {
        standalone_agent: {
          cluster: [_privileges.MONITOR_CLUSTER],
          indices: [withAPM ? _privileges.INDEX_LOGS_METRICS_AND_TRACES : _privileges.INDEX_LOGS_AND_METRICS]
        }
      }
    }
  });
}