"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocatorButtonEmpty = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Same as `EuiButtonEmpty` but uses locators to navigate instead of URLs.
 *
 * Accepts the following props instead of an `href`:
 * - `locator`: Either the URL locator public contract or the ID of the locator if previously registered.
 * - `params`: The params to pass to the locator.
 *
 * Get type safety for `params` by passing the correct type to the generic component.
 *
 * Example 1:
 *
 * ```ts
 * <LocatorButtonEmpty locator={dashboardStart.locator} params={{ dashboardId: 'abc' }}>
 *   View dashboard
 * </LocatorButtonEmpty>
 * ```
 *
 * Example 2:
 *
 * ```ts
 * import { type SingleDatasetLocatorParams, SINGLE_DATASET_LOCATOR_ID } from '@kbn/deeplinks-observability/locators';
 *
 * <LocatorButtonEmpty<SingleDatasetLocatorParams>
 *   locator={SINGLE_DATASET_LOCATOR_ID}
 *   params={{
 *     integration: 'system',
 *     dataset: 'system.syslog',
 *   }}
 * >
 *   View in Logs Explorer
 * </LocatorButtonEmpty>
 * ```
 */
const LocatorButtonEmpty = ({
  locator,
  params,
  ...rest
}) => {
  const {
    services: {
      share
    }
  } = (0, _public.useKibana)();
  const locatorObj = typeof locator === 'string' ? share.url.locators.get(locator) : locator;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "observabilityOnboardingLocatorButtonEmptyButton",
    href: locatorObj === null || locatorObj === void 0 ? void 0 : locatorObj.useUrl(params)
  }, rest));
};
exports.LocatorButtonEmpty = LocatorButtonEmpty;