"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelLogsPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _locators = require("@kbn/deeplinks-observability/locators");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _useAsyncFn = _interopRequireDefault(require("react-use/lib/useAsyncFn"));
var _i18nReact = require("@kbn/i18n-react");
var _ebtTools = require("@kbn/ebt-tools");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _multi_integration_install_banner = require("./multi_integration_install_banner");
var _empty_prompt = require("../shared/empty_prompt");
var _feedback_buttons = require("../shared/feedback_buttons");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_COMMAND = _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.p.runTheCommandOnYourHostLabel', {
  defaultMessage: 'Run the following command on your host to download and configure the collector.'
});
const OtelLogsPanel = () => {
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    services: {
      share,
      http,
      context: {
        isServerless,
        stackVersion
      }
    }
  } = (0, _public.useKibana)();
  const {
    data: setupData,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApi => {
    return callApi('POST /internal/observability_onboarding/otel_host/setup', {
      params: {
        query: {
          /**
           * This only needed for stateful deployments
           * of the stack version >=v8.18.0 <9.0.0.
           * On those clusters we cannot reference agent version
           * v8.x because those versions are not GA.
           * Instead we need to "manually" point to the GA
           * version, which starts from v9.0.0.
           */
          agentVersionPattern: '9.x.x'
        }
      }
    });
  }, [], {
    showToastOnError: false
  });
  (0, _react.useEffect)(() => {
    if (setupData) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Requests to setup the flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [onPageReady, setupData]);
  const AGENT_CDN_BASE_URL = 'artifacts.elastic.co/downloads/beats/elastic-agent';
  const agentVersion = selectAgentVersion(isServerless, stackVersion, setupData === null || setupData === void 0 ? void 0 : setupData.elasticAgentVersionInfo);
  const urlEncodedAgentVersion = encodeURIComponent(agentVersion);
  const allDatasetsLocator = share.url.locators.get(_locators.ALL_DATASETS_LOCATOR_ID);
  const hostsLocator = share.url.locators.get('HOSTS_LOCATOR');
  const [{
    value: deeplinks
  }, getDeeplinks] = (0, _useAsyncFn.default)(async () => {
    return {
      logs: allDatasetsLocator === null || allDatasetsLocator === void 0 ? void 0 : allDatasetsLocator.getRedirectUrl({
        type: 'logs'
      }),
      metrics: hostsLocator === null || hostsLocator === void 0 ? void 0 : hostsLocator.getRedirectUrl({})
    };
  }, [allDatasetsLocator]);
  (0, _react.useEffect)(() => {
    getDeeplinks();
  }, [getDeeplinks]);
  const sampleConfigurationPath = isServerless ? './otel_samples/managed_otlp/platformlogs_hostmetrics.yml' : './otel_samples/platformlogs_hostmetrics.yml';
  const elasticEndpointVarName = isServerless ? 'ELASTIC_OTLP_ENDPOINT' : 'ELASTIC_ENDPOINT';
  const installTabContents = [{
    id: 'linux',
    name: 'Linux',
    firstStepTitle: HOST_COMMAND,
    content: `arch=$(if [[ $(uname -m) == "arm" || $(uname -m) == "aarch64" ]]; then echo "arm64"; else echo $(uname -m); fi)

curl --output elastic-distro-${agentVersion}-linux-$arch.tar.gz --url https://${AGENT_CDN_BASE_URL}/elastic-agent-${urlEncodedAgentVersion}-linux-$arch.tar.gz --proto '=https' --tlsv1.2 -fL && mkdir -p elastic-distro-${agentVersion}-linux-$arch && tar -xvf elastic-distro-${agentVersion}-linux-$arch.tar.gz -C "elastic-distro-${agentVersion}-linux-$arch" --strip-components=1 && cd elastic-distro-${agentVersion}-linux-$arch

rm ./otel.yml && cp ${sampleConfigurationPath} ./otel.yml && mkdir -p ./data/otelcol && sed -i 's#\\\${env:STORAGE_DIR}#'"$PWD"/data/otelcol'#g' ./otel.yml && sed -i 's#\\\${env:${elasticEndpointVarName}}#${setupData === null || setupData === void 0 ? void 0 : setupData.elasticsearchUrl}#g' ./otel.yml && sed -i 's/\\\${env:ELASTIC_API_KEY}/${setupData === null || setupData === void 0 ? void 0 : setupData.apiKeyEncoded}/g' ./otel.yml`,
    start: 'sudo ./otelcol --config otel.yml',
    type: 'copy'
  }, {
    id: 'mac',
    name: 'Mac',
    firstStepTitle: HOST_COMMAND,
    content: `arch=$(if [[ $(uname -m) == "arm64" ]]; then echo "aarch64"; else echo $(uname -m); fi)

curl --output elastic-distro-${agentVersion}-darwin-$arch.tar.gz --url https://${AGENT_CDN_BASE_URL}/elastic-agent-${urlEncodedAgentVersion}-darwin-$arch.tar.gz --proto '=https' --tlsv1.2 -fL && mkdir -p "elastic-distro-${agentVersion}-darwin-$arch" && tar -xvf elastic-distro-${agentVersion}-darwin-$arch.tar.gz -C "elastic-distro-${agentVersion}-darwin-$arch" --strip-components=1 && cd elastic-distro-${agentVersion}-darwin-$arch

rm ./otel.yml && cp ${sampleConfigurationPath} ./otel.yml && mkdir -p ./data/otelcol  && sed -i '' 's#\\\${env:STORAGE_DIR}#'"$PWD"/data/otelcol'#g' ./otel.yml && sed -i '' 's#\\\${env:${elasticEndpointVarName}}#${setupData === null || setupData === void 0 ? void 0 : setupData.elasticsearchUrl}#g' ./otel.yml && sed -i '' 's/\\\${env:ELASTIC_API_KEY}/${setupData === null || setupData === void 0 ? void 0 : setupData.apiKeyEncoded}/g' ./otel.yml`,
    start: './otelcol --config otel.yml',
    type: 'copy'
  }];
  const [selectedTab, setSelectedTab] = _react.default.useState(installTabContents[0].id);
  const selectedContent = installTabContents.find(tab => tab.id === selectedTab);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "otel_logs",
      error: error,
      onRetryClick: refetch
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_multi_integration_install_banner.MultiIntegrationInstallBanner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.steps.platform', {
        defaultMessage: 'Select your platform'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        legend: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.choosePlatform', {
          defaultMessage: 'Choose platform'
        }),
        options: installTabContents.map(({
          id,
          name
        }) => ({
          id,
          label: name
        })),
        type: "single",
        idSelected: selectedTab,
        onChange: id => {
          setSelectedTab(id);
        }
      }), !setupData && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 6
      }), setupData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, selectedContent.firstStepTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        language: "sh",
        isCopyable: true,
        overflowHeight: 300
      }, selectedContent.content)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        align: "left"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
        textToCopy: selectedContent.content
      }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "observabilityOnboardingOtelLogsPanelButton",
        iconType: "copyClipboard",
        onClick: copy
      }, _i18n.i18n.translate('xpack.observability_onboarding.installOtelCollector.configStep.copyCommand', {
        defaultMessage: 'Copy to clipboard'
      })))))))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.steps.start', {
        defaultMessage: 'Start the collector'
      }),
      children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.limitationTitle', {
          defaultMessage: 'Configuration Information'
        }),
        color: "warning",
        iconType: "info"
      }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.historicalDataDescription', {
        defaultMessage: 'New log messages are collected from the setup onward.'
      })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.historicalDataDescription2', {
        defaultMessage: 'The default log path is /var/log/*. You can change this path in the otel.yml file if needed.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.p.startTheCollectorLabel', {
        defaultMessage: 'Run the following command to start the collector'
      }))), /*#__PURE__*/_react.default.createElement(CopyableCodeBlock, {
        content: selectedContent.start
      }))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.steps.visualize', {
        defaultMessage: 'Visualize your data'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.waitForTheDataLabel', {
        defaultMessage: 'After running the previous command, come back and view your data.'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        src: http === null || http === void 0 ? void 0 : http.staticAssets.getPluginAssetHref('waterfall_screen.svg'),
        width: 160,
        alt: "Illustration",
        hasShadow: true
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs"
      }, (deeplinks === null || deeplinks === void 0 ? void 0 : deeplinks.logs) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.viewAndAnalyzeYourTextLabel', {
        defaultMessage: 'View and analyze your logs'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "obltOnboardingExploreLogs",
        href: deeplinks.logs
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.exploreLogs', {
        defaultMessage: 'Open Logs Explorer'
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), (deeplinks === null || deeplinks === void 0 ? void 0 : deeplinks.metrics) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.viewAndAnalyzeYourMetricsTextLabel', {
        defaultMessage: 'View and analyze your metrics'
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "obltOnboardingExploreMetrics",
        href: deeplinks.metrics
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.exploreMetrics', {
        defaultMessage: 'Open Hosts'
      }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelLogsPanel.troubleshooting",
        defaultMessage: "Find more details and troubleshooting solution in our documentation. {link}",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "observabilityOnboardingOtelLogsPanelDocumentationLink",
            href: "https://ela.st/elastic-otel",
            target: "_blank",
            external: true
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogsPanel.documentationLink', {
            defaultMessage: 'Open documentation'
          }))
        }
      })))
    }]
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "otel_logs"
  })));
};
exports.OtelLogsPanel = OtelLogsPanel;
function CopyableCodeBlock({
  content
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml"
  }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: content
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityOnboardingCopyableCodeBlockCopyToClipboardButton",
    iconType: "copyClipboard",
    onClick: copy
  }, _i18n.i18n.translate('xpack.observability_onboarding.installOtelCollector.configStep.copyCommand', {
    defaultMessage: 'Copy to clipboard'
  }))));
}
function selectAgentVersion(isServerless, stackVersion, agentVersionInfo) {
  var _agentVersionInfo$age;
  if (!agentVersionInfo) {
    return stackVersion;
  }
  if (isServerless) {
    return agentVersionInfo.agentVersion;
  }
  return (_agentVersionInfo$age = agentVersionInfo.agentTargetVersion) !== null && _agentVersionInfo$age !== void 0 ? _agentVersionInfo$age : stackVersion;
}