"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFirehoseFlow = useFirehoseFlow;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = require("react");
var _telemetry_events = require("../../../../common/telemetry_events");
var _use_fetcher = require("../../../hooks/use_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFirehoseFlow() {
  const {
    services: {
      analytics,
      context: {
        cloudServiceProvider
      }
    }
  } = (0, _public.useKibana)();
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApi => {
    return callApi('POST /internal/observability_onboarding/firehose/flow');
  }, [], {
    showToastOnError: false
  });
  (0, _react.useEffect)(() => {
    if ((data === null || data === void 0 ? void 0 : data.onboardingId) !== undefined) {
      analytics === null || analytics === void 0 ? void 0 : analytics.reportEvent(_telemetry_events.OBSERVABILITY_ONBOARDING_FLOW_PROGRESS_TELEMETRY_EVENT.eventType, {
        onboardingFlowType: 'firehose',
        onboardingId: data === null || data === void 0 ? void 0 : data.onboardingId,
        step: 'in_progress',
        context: {
          firehose: {
            cloudServiceProvider
          }
        }
      });
    }
  }, [analytics, cloudServiceProvider, data === null || data === void 0 ? void 0 : data.onboardingId]);
  return {
    data,
    status,
    error,
    refetch
  };
}