"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStackCommandSnippet = CreateStackCommandSnippet;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _aws_firehose = require("../../../../common/aws_firehose");
var _copy_to_clipboard_button = require("../shared/copy_to_clipboard_button");
var _download_template_callout = require("./download_template_callout");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function CreateStackCommandSnippet({
  encodedApiKey,
  elasticsearchUrl,
  templateUrl,
  isCopyPrimaryAction
}) {
  const stackStatusAccordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'stackStatusAccordion'
  });
  const createStackCommand = (0, _utils.buildCreateStackCommand)({
    templateUrl,
    stackName: _aws_firehose.FIREHOSE_CLOUDFORMATION_STACK_NAME,
    streamName: _aws_firehose.FIREHOSE_STREAM_NAME,
    encodedApiKey,
    elasticsearchUrl
  });
  const stackStatusCommand = (0, _utils.buildStackStatusCommand)({
    stackName: _aws_firehose.FIREHOSE_CLOUDFORMATION_STACK_NAME
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.firehosePanel.createFirehoseStreamDescription",
    defaultMessage: "Run the command bellow in your terminal where you have {awsCLIInstallGuideLink} configured. The command will create a CloudFormation stack from our template that includes a Firehose delivery, backup S3 bucket, CloudWatch subscription filter and metrics stream along with required IAM roles.",
    values: {
      awsCLIInstallGuideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "observabilityOnboardingFirehosePanelAwsInstallGuideLink",
        href: "https://docs.aws.amazon.com/cli/latest/userguide/getting-started-install.html",
        external: true,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.awsCLIInstallGuideLinkLabel', {
        defaultMessage: 'AWS CLI'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_download_template_callout.DownloadTemplateCallout, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "text",
    paddingSize: "m",
    fontSize: "m",
    "data-test-subj": "observabilityOnboardingFirehoseCreateStackCommand"
  }, createStackCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
    textToCopy: createStackCommand,
    fill: isCopyPrimaryAction
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: stackStatusAccordionId,
    buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.firehosePanel.stackStatusAccordionButtonLabel', {
      defaultMessage: 'Check status of the CloudFormation stack'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "text",
    paddingSize: "m",
    fontSize: "m",
    isCopyable: true
  }, stackStatusCommand)));
}