"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoDetectPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _template = require("./template");
var _custom_header = require("../header/custom_header");
var _auto_detect = require("../quickstart_flows/auto_detect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutoDetectPage = () => /*#__PURE__*/_react.default.createElement(_template.PageTemplate, {
  customHeader: /*#__PURE__*/_react.default.createElement(_custom_header.CustomHeader, {
    euiIconType: "consoleApp",
    headlineCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.system.text', {
      defaultMessage: 'Auto-detect logs and metrics'
    }),
    captionCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.system.description', {
      defaultMessage: 'This installation scans your host and auto-detects log and metric files.'
    })
  })
}, /*#__PURE__*/_react.default.createElement(_auto_detect.AutoDetectPanel, null));
exports.AutoDetectPage = AutoDetectPage;