"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeAllSelection = void 0;
var _common = require("@kbn/logs-explorer-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeAllSelection = ({
  logSourcesService
}) => async context => {
  const logSources = await logSourcesService.getLogSources();
  const indices = logSources.map(logSource => logSource.indexPattern).join(',');
  return _common.AllDatasetSelection.create({
    indices
  });
};
exports.initializeAllSelection = initializeAllSelection;