"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderLastUsedLogsViewerRedirect = exports.LastUsedLogsViewerRedirect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderLastUsedLogsViewerRedirect = (core, appParams) => {
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: appParams.history
  }, /*#__PURE__*/_react.default.createElement(LastUsedLogsViewerRedirect, {
    core: core
  })), appParams.element);
  return () => {
    _reactDom.default.unmountComponentAtNode(appParams.element);
  };
};
exports.renderLastUsedLogsViewerRedirect = renderLastUsedLogsViewerRedirect;
const LastUsedLogsViewerRedirect = ({
  core
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const path = `${location.pathname}${location.search}`;
  const [lastUsedLogsViewApp] = (0, _useLocalStorage.default)(_deeplinksObservability.OBS_LOGS_EXPLORER_LOGS_VIEWER_KEY, _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID);
  if (lastUsedLogsViewApp && lastUsedLogsViewApp !== _deeplinksAnalytics.DISCOVER_APP_ID && lastUsedLogsViewApp !== _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID) {
    throw new Error(`Invalid last used logs viewer app: "${lastUsedLogsViewApp}". Allowed values are "${_deeplinksAnalytics.DISCOVER_APP_ID}" and "${_deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID}"`);
  }
  (0, _react.useEffect)(() => {
    if (lastUsedLogsViewApp === _deeplinksAnalytics.DISCOVER_APP_ID) {
      core.application.navigateToApp(_deeplinksAnalytics.DISCOVER_APP_ID, {
        replace: true,
        path
      });
    }
    if (lastUsedLogsViewApp === _deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID) {
      core.application.navigateToApp(_deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID, {
        replace: true,
        path
      });
    }
  }, [core, path, lastUsedLogsViewApp]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
exports.LastUsedLogsViewerRedirect = LastUsedLogsViewerRedirect;