"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.observableIntoOpenAIStream = observableIntoOpenAIStream;
var _rxjs = require("rxjs");
var _stream = require("stream");
var _conversation_complete = require("../../../common/conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function observableIntoOpenAIStream(source, logger) {
  const stream = new _stream.PassThrough();
  source.pipe((0, _rxjs.filter)(event => event.type === _conversation_complete.StreamingChatResponseEventType.ChatCompletionChunk), (0, _rxjs.map)(event => {
    const chunk = {
      model: 'unknown',
      choices: [{
        delta: {
          content: event.message.content,
          function_call: event.message.function_call
        },
        finish_reason: null,
        index: 0
      }],
      created: new Date().getTime(),
      id: event.id,
      object: 'chat.completion.chunk'
    };
    return JSON.stringify(chunk);
  }), (0, _rxjs.catchError)(error => {
    return (0, _rxjs.of)(JSON.stringify({
      error: {
        message: error.message
      }
    }));
  }), (0, _rxjs.endWith)('[DONE]'), (0, _rxjs.concatMap)(line => {
    return (0, _rxjs.from)(new Promise((resolve, reject) => {
      stream.write(`data: ${line}\n\n`, err => {
        if (err) {
          return reject(err);
        }
        resolve();
      });
    }));
  }), (0, _rxjs.ignoreElements)()).subscribe({
    error: error => {
      logger.error('Error writing stream');
      logger.error(JSON.stringify(error));
      stream.end(error);
    },
    complete: () => {
      stream.end();
    }
  });
  return stream;
}