"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateKnowledgeBaseWriteIndexAlias = updateKnowledgeBaseWriteIndexAlias;
var _ = require("..");
var _index_write_block_utils = require("./index_write_block_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateKnowledgeBaseWriteIndexAlias({
  esClient,
  logger,
  nextWriteIndexName,
  currentWriteIndexName
}) {
  logger.debug(`Updating write index alias from "${currentWriteIndexName}" to "${nextWriteIndexName}"`);
  const alias = _.resourceNames.writeIndexAlias.kb;
  try {
    await (0, _index_write_block_utils.addIndexWriteBlock)({
      esClient,
      index: currentWriteIndexName
    });
    logger.debug(`Added write block to "${currentWriteIndexName}". It is now read-only and writes are temporarily blocked.`);
    await esClient.asInternalUser.indices.updateAliases({
      actions: [{
        remove: {
          index: currentWriteIndexName,
          alias
        }
      }, {
        add: {
          index: nextWriteIndexName,
          alias,
          is_write_index: true
        }
      }]
    });
  } catch (error) {
    await (0, _index_write_block_utils.removeIndexWriteBlock)({
      esClient,
      index: currentWriteIndexName
    });
    logger.error(`Failed to update write index alias: ${error.message}. Reverting back to ${currentWriteIndexName}`);
    throw error;
  }
  logger.debug(`Successfully updated write index alias to "${nextWriteIndexName}". Writes are now enabled again.`);
}