"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInferenceEndpointExists = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isInferenceEndpointExists = async (http, inferenceEndpointId) => {
  try {
    return (await http.get(`/internal/_inference/_exists/${inferenceEndpointId}`, {
      version: '1'
    })).isEndpointExists;
  } catch (err) {
    return false;
  }
};
exports.isInferenceEndpointExists = isInferenceEndpointExists;