"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SELECTED_CONNECTOR_LOCAL_STORAGE_KEY = void 0;
exports.SearchConnectorTab = SearchConnectorTab;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECTED_CONNECTOR_LOCAL_STORAGE_KEY = exports.SELECTED_CONNECTOR_LOCAL_STORAGE_KEY = 'xpack.observabilityAiAssistant.lastUsedConnector';
function SearchConnectorTab() {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const url = application.getUrlForApp('elasticsearch', {
    path: '/content/connectors'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.searchConnectorTab.searchConnectorsEnablesYouTextLabel', {
    defaultMessage: 'Connectors enable you to index content from external sources thereby making it available for the AI Assistant. This can greatly improve the relevance of the AI Assistant’s responses.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observabilityAiAssistantManagement.searchConnectorTab.searchConnectorsManagementLink",
    defaultMessage: "You can manage connectors under {searchConnectorLink}.",
    values: {
      searchConnectorLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "pluginsSearchConnectorTabSearchConnectorsManagementPageLink",
        href: url
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.searchConnectorTab.searchConnectorsManagementPageLinkLabel', {
        defaultMessage: 'Connectors'
      }))
    }
  })));
}