"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisObservationPanel = RootCauseAnalysisObservationPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _rca_collapsible_panel = require("../rca_collapsible_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RootCauseAnalysisObservationPanel({
  content,
  title,
  loading
}) {
  const theme = (0, _eui.useEuiTheme)().euiTheme;
  return /*#__PURE__*/_react.default.createElement(_rca_collapsible_panel.RootCauseAnalysisCollapsiblePanel, {
    isDisabled: loading,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      className: (0, _css.css)`
              color: ${loading ? theme.colors.subduedText : theme.colors.text};
              white-space: nowrap;
            `
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.observationPanelTitle', {
      defaultMessage: 'Observations'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: loading ? theme.colors.subduedText : theme.colors.text
    }, title), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s"
    }) : null))),
    color: "success",
    content: content ? /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      textSize: "s"
    }, content) : null
  });
}