"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisCallout = RootCauseAnalysisCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RootCauseAnalysisCallout({
  onClick,
  onCompleteInBackgroundClick,
  completeInBackground
}) {
  const checkboxId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    hasShadow: false,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center",
    className: (0, _css.css)`
              max-width: 512px;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.calloutTitle', {
    defaultMessage: 'AI-assisted root cause analysis'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.calloutText', {
    defaultMessage: `Start an automated investigation that will analyze
              log patterns, SLOs and alerts for entities and provide an evidence-
              based root cause analysis of issues in your system.`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: checkboxId,
    onChange: () => {
      onCompleteInBackgroundClick();
    },
    checked: completeInBackground
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: checkboxId
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rootCauseAnalysisCallout.keepAnalysisRunningInFormLabelLabel', {
    defaultMessage: 'Keep analysis running in background'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilityAiAssistantAppRootCauseAnalysisCalloutStartAnalysisButton",
    iconType: "sparkles",
    fill: true,
    onClick: onClick
  }, _i18n.i18n.translate('xpack.observabilityAiAssistant.rca.calloutText', {
    defaultMessage: 'Start analysis'
  })))))));
}