"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unflattenObject = unflattenObject;
var _saferLodashSet = require("@kbn/safer-lodash-set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function unflattenObject(source, target = {}) {
  // eslint-disable-next-line guard-for-in
  for (const key in source) {
    const val = source[key];
    if (Array.isArray(val)) {
      const unflattenedArray = val.map(item => {
        if (item && typeof item === 'object' && !Array.isArray(item)) {
          return unflattenObject(item);
        }
        return item;
      });
      (0, _saferLodashSet.set)(target, key, unflattenedArray);
    } else {
      (0, _saferLodashSet.set)(target, key, val);
    }
  }
  return target;
}