"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoData = NoData;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _setup_mode = require("../../lib/setup_mode");
var _checking_settings = require("./checking_settings");
var _reasons = require("./reasons");
var _checker_errors = require("./checker_errors");
var _blurbs = require("./blurbs");
var _get_safe_for_external_link = require("../../lib/get_safe_for_external_link");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NoDataMessage(props) {
  const {
    isLoading,
    reason,
    checkMessage,
    isCollectionEnabledUpdated
  } = props;
  if (isCollectionEnabledUpdated && !reason || isLoading) {
    return /*#__PURE__*/_react.default.createElement(_checking_settings.CheckingSettings, {
      checkMessage: checkMessage
    });
  }
  if (reason) {
    return /*#__PURE__*/_react.default.createElement(_reasons.ReasonFound, props);
  }
  return /*#__PURE__*/_react.default.createElement(_reasons.WeTried, null);
}
function NoData(props) {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [useInternalCollection, setUseInternalCollection] = (0, _react.useState)(false);
  const isCloudEnabled = props.isCloudEnabled;
  async function startSetup() {
    setIsLoading(true);
    await (0, _setup_mode.toggleSetupMode)(true);
    window.location.hash = (0, _get_safe_for_external_link.getSafeForExternalLink)('#/elasticsearch/nodes');
  }
  const NoDataContainer = ({
    children
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
      "data-test-subj": "noDataContainer"
    }, children);
  };
  if (isCloudEnabled) {
    return /*#__PURE__*/_react.default.createElement(NoDataContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.cloud.heading",
      defaultMessage: "No monitoring data found."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      restrictWidth: 600
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "monitoringApp",
        size: "xxl"
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.noData.cloud.title",
        defaultMessage: "Monitoring data not available"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.noData.cloud.description",
        defaultMessage: "Monitoring provides insight to your hardware performance and load."
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        size: "half"
      }), /*#__PURE__*/_react.default.createElement(_blurbs.CloudDeployment, null))
    })));
  }
  if (useInternalCollection) {
    return /*#__PURE__*/_react.default.createElement(NoDataContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.no_data.internal_collection.heading",
      defaultMessage: "No monitoring data found."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
      restrictWidth: 600
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "monitoringApp",
        size: "xxl"
      }),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(NoDataMessage, props), /*#__PURE__*/_react.default.createElement(_checker_errors.CheckerErrors, {
        errors: props.errors
      })),
      actions: !props.isCloudEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        size: "half"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        isDisabled: props.isCollectionEnabledUpdated,
        onClick: () => setUseInternalCollection(false)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "default"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.noData.setupMetricbeatInstead",
        defaultMessage: "Or, set up with Metricbeat (recommended)"
      })))) : null
    })));
  }
  return /*#__PURE__*/_react.default.createElement(NoDataContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.no_data.heading",
    defaultMessage: "No monitoring data found."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 600
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "monitoringApp",
      size: "xxl"
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.noMonitoringDetected",
      defaultMessage: "No monitoring data found"
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.noMonitoringDataFound",
      defaultMessage: "Have you set up monitoring yet? If so, make sure that the selected time period in the upper right includes monitoring data."
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.remoteCollectionNotice",
      defaultMessage: "If you have configured monitoring data to be sent to a dedicated monitoring cluster you should access that data with the Kibana instance attached to the monitoring cluster."
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceAround",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: startSetup,
      type: "button",
      "data-test-subj": "enableCollectionInterval",
      isLoading: isLoading
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.collectionInterval.turnOnMonitoringButtonLabel",
      defaultMessage: "Set up monitoring with Metricbeat"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "half"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => setUseInternalCollection(true),
      "data-test-subj": "useInternalCollection"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.noData.setupInternalInstead",
      defaultMessage: "Or, set up with self monitoring"
    }))))
  })));
}
NoData.propTypes = {
  isLoading: _propTypes.default.bool.isRequired,
  reason: _propTypes.default.object,
  checkMessage: _propTypes.default.string
};