"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PainlessLexerEnhanced = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _painless_lexer = _interopRequireDefault(require("../../antlr/painless_lexer"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * This extends the PainlessLexer class in order to handle backslashes appropriately
 * It is being invoked in painless_lexer.g4
 * Based on the Java implementation: https://github.com/elastic/elasticsearch/blob/feab123ba400b150f3dcd04dd27cf57474b70d5a/modules/lang-painless/src/main/java/org/elasticsearch/painless/antlr/EnhancedPainlessLexer.java#L73
 */
class PainlessLexerEnhanced extends _painless_lexer.default {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "lastToken", void 0);
  }
  nextToken() {
    this.lastToken = super.nextToken();
    return this.lastToken;
  }
  isSlashRegex() {
    var _this$lastToken;
    switch ((_this$lastToken = this.lastToken) === null || _this$lastToken === void 0 ? void 0 : _this$lastToken.type) {
      case _painless_lexer.default.RBRACE:
      case _painless_lexer.default.RP:
      case _painless_lexer.default.OCTAL:
      case _painless_lexer.default.HEX:
      case _painless_lexer.default.INTEGER:
      case _painless_lexer.default.DECIMAL:
      case _painless_lexer.default.ID:
      case _painless_lexer.default.DOTINTEGER:
      case _painless_lexer.default.DOTID:
        return false;
      default:
        return true;
    }
  }
}
exports.PainlessLexerEnhanced = PainlessLexerEnhanced;