"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lexerRules = exports.keywords = exports.builtinFunctions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const brackets = [{
  open: '[',
  close: ']',
  token: 'delimiter.square'
}, {
  open: '(',
  close: ')',
  token: 'delimiter.parenthesis'
}];

// These are extracted from the antler esql lexer rules file:
// src/platform/packages/shared/kbn-esql-ast/src/antlr/esql_lexer.ts
const keywords = exports.keywords = ['dissect', 'drop', 'enrich', 'eval', 'explain', 'from', 'grok', 'keep', 'limit', 'mv_expand', 'rename', 'row', 'show', 'sort', 'stats', 'where', 'by', 'and', 'asc', 'desc', 'first', 'in', 'is', 'last', 'like', 'not', 'or', 'rlike', 'metadata', 'as', 'on', 'with', 'info', 'using'];

// These are extracted from the autogenerated list of functions located at:
// src/platform/packages/private/kbn-language-documentation/src/sections/generated
const builtinFunctions = exports.builtinFunctions = [
// Functions
'ABS', 'ACOS', 'ASIN', 'ATAN', 'ATAN2', 'BIT_LENGTH', 'BUCKET', 'BYTE_LENGTH', 'CASE', 'CATEGORIZE', 'CBRT', 'CEIL', 'CIDR_MATCH', 'COALESCE', 'CONCAT', 'COS', 'COSH', 'DATE_DIFF', 'DATE_EXTRACT', 'DATE_FORMAT', 'DATE_PARSE', 'DATE_TRUNC', 'E', 'ENDS_WITH', 'EXP', 'FLOOR', 'FROM_BASE64', 'GREATEST', 'HASH', 'HYPOT', 'IP_PREFIX', 'LEAST', 'LEFT', 'LENGTH', 'LOCATE', 'LOG', 'LOG10', 'LTRIM', 'MATCH', 'MV_APPEND', 'MV_AVG', 'MV_CONCAT', 'MV_COUNT', 'MV_DEDUPE', 'MV_FIRST', 'MV_LAST', 'MV_MAX', 'MV_MEDIAN', 'MV_MEDIAN_ABSOLUTE_DEVIATION', 'MV_MIN', 'MV_PERCENTILE', 'MV_PSERIES_WEIGHTED_SUM', 'MV_SLICE', 'MV_SORT', 'MV_SUM', 'MV_ZIP', 'NOW', 'PI', 'POW', 'QSTR', 'REPEAT', 'REPLACE', 'REVERSE', 'RIGHT', 'ROUND', 'RTRIM', 'SIGNUM', 'SIN', 'SINH', 'SPACE', 'SPLIT', 'SQRT', 'ST_CONTAINS', 'ST_DISJOINT', 'ST_DISTANCE', 'ST_ENVELOPE', 'ST_INTERSECTS', 'ST_WITHIN', 'ST_X', 'ST_XMAX', 'ST_XMIN', 'ST_Y', 'ST_YMAX', 'ST_YMIN', 'STARTS_WITH', 'SUBSTRING', 'TAN', 'TANH', 'TAU', 'TO_BASE64', 'TO_BOOLEAN', 'TO_CARTESIANPOINT', 'TO_CARTESIANSHAPE', 'TO_DATE_NANOS', 'TO_DATEPERIOD', 'TO_DATETIME', 'TO_DEGREES', 'TO_DOUBLE', 'TO_GEOPOINT', 'TO_GEOSHAPE', 'TO_INTEGER', 'TO_IP', 'TO_LONG', 'TO_LOWER', 'TO_RADIANS', 'TO_STRING', 'TO_TIMEDURATION', 'TO_UNSIGNED_LONG', 'TO_UPPER', 'TO_VERSION', 'TRIM',
// Aggregation functions
'AVG', 'COUNT', 'COUNT_DISTINCT', 'MAX', 'MEDIAN', 'MEDIAN_ABSOLUTE_DEVIATION', 'MIN', 'PERCENTILE', 'ST_CENTROID_AGG', 'ST_EXTENT_AGG', 'STD_DEV', 'SUM', 'TOP', 'VALUES', 'WEIGHTED_AVG'];

// These ESQL lexer rules are only used for highlighting nested ESQL in Console requests
const lexerRules = exports.lexerRules = {
  defaultToken: 'invalid',
  ignoreCase: true,
  tokenPostfix: '',
  keywords,
  builtinFunctions,
  brackets,
  tokenizer: {
    root: [[/[a-zA-Z_$][a-zA-Z0-9_$]*\b/, {
      cases: {
        '@keywords': 'keyword',
        '@builtinFunctions': 'keyword',
        '@default': 'identifier'
      }
    }], [/[()]/, '@brackets'], [/\/\/.*$/, 'comment'], [/\/\*/, 'comment', '@comment'], [/".*?"/, 'string'], [/'.*?'/, 'constant'], [/`.*?`/, 'string'],
    // whitespace
    [/[ \t\r\n]+/, {
      token: '@whitespace'
    }], [/[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b/, 'entity.name.function'], [/⇐|<⇒|\*|\.|\:\:|\+|\-|\/|\/\/|%|&|\^|~|<|>|<=|=>|==|!=|<>|=/, 'keyword.operator'], [/[\(]/, 'paren.lparen'], [/[\)]/, 'paren.rparen'], [/\s+/, 'text']],
    numbers: [[/0[xX][0-9a-fA-F]*/, 'number'], [/[$][+-]*\d*(\.\d*)?/, 'number'], [/((\d+(\.\d*)?)|(\.\d+))([eE][\-+]?\d+)?/, 'number']],
    strings: [[/N'/, {
      token: 'string',
      next: '@string'
    }], [/'/, {
      token: 'string',
      next: '@string'
    }]],
    string: [[/[^']+/, 'string'], [/''/, 'string'], [/'/, {
      token: 'string',
      next: '@pop'
    }]],
    comment: [[/[^\/*]+/, 'comment'], [/\*\//, 'comment', '@pop'], [/[\/*]/, 'comment']]
  }
};