/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.ml_bundle_jsonpfunction=self.ml_bundle_jsonpfunction||[]).push([[1512],{11512:(e,l,s)=>{s.r(l),s.d(l,{AddModelFlyout:()=>c});var t=s(81319),d=s(75879),o=s(84286),a=s.n(o),i=s(30770),n=s(26192),r=s(13493),u=s(75008),m=s(96791);const x=({supportedNlpModels:e,nlpImportModel:l})=>(0,m.jsx)(a().Fragment,null,(0,m.jsx)(t.EuiSpacer,{size:"m"}),(0,m.jsx)(t.EuiSteps,{steps:[{title:u.i18n.translate("xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step1Title",{defaultMessage:"Install the Eland Python Client"}),children:(0,m.jsx)(t.EuiText,null,(0,m.jsx)(t.EuiText,{size:"s",color:"subdued"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.pipInstallLabel",defaultMessage:"Eland can be installed with {pipLink} from {pypiLink}:",values:{pipLink:(0,m.jsx)(t.EuiLink,{href:"https://pypi.org/project/pip/",target:"_blank",external:!0},"pip"),pypiLink:(0,m.jsx)(t.EuiLink,{href:"https://pypi.org/",target:"_blank",external:!0},"PyPI")}})),(0,m.jsx)(t.EuiCodeBlock,{isCopyable:!0,language:"shell",fontSize:"m","data-test-subj":"mlElandPipInstallCodeBlock"},(0,m.jsx)("p",null,"$ python -m pip install eland")),(0,m.jsx)(t.EuiText,{size:"s",color:"subdued"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.condaInstallLabel",defaultMessage:"or it can also be installed with {condaLink} from {condaForgeLink}:",values:{condaLink:(0,m.jsx)(t.EuiLink,{href:"https://docs.conda.io/",target:"_blank",external:!0},"Conda"),condaForgeLink:(0,m.jsx)(t.EuiLink,{href:"https://conda-forge.org/",target:"_blank",external:!0},"Conda Forge")}})),(0,m.jsx)(t.EuiCodeBlock,{isCopyable:!0,language:"shell",fontSize:"m","data-test-subj":"mlElandCondaInstallCodeBlock"},(0,m.jsx)("p",null," $ conda install -c conda-forge eland")))},{title:u.i18n.translate("xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2Title",{defaultMessage:"Importing your third-party model"}),children:(0,m.jsx)(t.EuiText,null,(0,m.jsx)("p",null,(0,m.jsx)(t.EuiText,{size:"s",color:"subdued"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2Body",defaultMessage:"Follow the instructions on importing compatible third-party models"}))),(0,m.jsx)("p",null,(0,m.jsx)("b",null,(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step2ExampleTitle",defaultMessage:"Example import"})),(0,m.jsx)(t.EuiCodeBlock,{isCopyable:!0,language:"shell",fontSize:"m","data-test-subj":"mlElandExampleImportCodeBlock"},"eland_import_hub_model ",(0,m.jsx)("br",null),"--cloud-id <cloud-id> \\ ",(0,m.jsx)("br",null),"-u <username> -p <password> \\ ",(0,m.jsx)("br",null),"--hub-model-id <model-id> \\ ",(0,m.jsx)("br",null),"--task-type ner \\")),(0,m.jsx)(t.EuiFlexGroup,{gutterSize:"s"},(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiButtonEmpty,{href:l,target:"_blank",iconType:"help"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.importModelButtonLabel",defaultMessage:"Import models with Eland"}))),(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiButtonEmpty,{href:e,target:"_blank",iconType:"help"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.compatibleModelsButtonLabel",defaultMessage:"Compatible NLP models"})))))},{title:u.i18n.translate("xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step4Title",{defaultMessage:"Deploy your model"}),children:(0,m.jsx)(a().Fragment,null,(0,m.jsx)(t.EuiText,{size:"s",color:"subdued"},(0,m.jsx)("p",null,(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step4Body",defaultMessage:"Click “Start deployment” in the table row containing your new model to deploy and use it."}))),(0,m.jsx)(t.EuiSpacer,{size:"m"}),(0,m.jsx)(t.EuiText,{size:"s",color:"subdued"},(0,m.jsx)("p",null,(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elandPythonClient.step3Body",defaultMessage:"Note: The trained model list automatically refreshes with the most current imported models in your cluster. If the list is not updated, click the 'Refresh' button in the top right corner. Otherwise, revisit the instructions above to troubleshoot."}))))}]})),c=({onClose:e,onSubmit:l,modelDownloads:s})=>{const a=(0,n.usePermissionCheck)("canCreateTrainedModels")&&s.length>0,[i,r]=(0,o.useState)(a?"clickToDownload":"manualDownload"),u=(0,o.useMemo)((()=>[...a?[{id:"clickToDownload",name:(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.clickToDownloadTabLabel",defaultMessage:"Click to Download"}),content:(0,m.jsx)(p,{modelDownloads:s,onModelDownload:l})}]:[],{id:"manualDownload",name:(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.thirdPartyLabel",defaultMessage:"Manual Download"}),content:(0,m.jsx)(j,null)}]),[a,s,l]),x=(0,o.useMemo)((()=>{var e;return null===(e=u.find((e=>e.id===i)))||void 0===e?void 0:e.content}),[i,u]);return(0,m.jsx)(t.EuiFlyout,{ownFocus:!0,onClose:e,"aria-labelledby":"addTrainedModelFlyout","data-test-subj":"mlAddTrainedModelFlyout"},(0,m.jsx)(t.EuiFlyoutHeader,null,(0,m.jsx)(t.EuiTitle,{size:"m"},(0,m.jsx)("h2",{id:"addTrainedModelFlyout"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.title",defaultMessage:"Add a trained model"}))),(0,m.jsx)(t.EuiTabs,null,u.map((e=>(0,m.jsx)(t.EuiTab,{key:e.id,isSelected:i===e.id,onClick:r.bind(null,e.id),"data-test-subj":`mlAddTrainedModelFlyoutTab ${e.id}`},e.name))))),(0,m.jsx)(t.EuiFlyoutBody,null,x),(0,m.jsx)(t.EuiFlyoutFooter,null,(0,m.jsx)(t.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiButtonEmpty,{iconType:"cross",onClick:e,flush:"left"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.closeButtonLabel",defaultMessage:"Close"}))))))},p=({modelDownloads:e,onModelDownload:l})=>{var s;const{services:{docLinks:n}}=(0,r.hk)(),[u,x]=(0,o.useState)(null===(s=e.find((e=>e.recommended)))||void 0===s?void 0:s.model_id);return(0,m.jsx)(a().Fragment,null,Object.entries((0,i.groupBy)(e,"modelName")).map((([e,l])=>(0,m.jsx)(a().Fragment,{key:e},"elser"===e?(0,m.jsx)("div",null,(0,m.jsx)(t.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiIcon,{type:"logoElastic",size:"l"})),(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiTitle,{size:"s"},(0,m.jsx)("h3",null,(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.elserTitle",defaultMessage:"ELSER (Elastic Learned Sparse EncodeR)"}))))),(0,m.jsx)(t.EuiSpacer,{size:"s"}),(0,m.jsx)("p",null,(0,m.jsx)(t.EuiText,{color:"subdued",size:"s","data-test-subj":"mlAddTrainedModelFlyoutElserModelHeaderCopy"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.elserDescription",defaultMessage:"ELSER is Elastic's NLP model for English semantic search, utilizing sparse vectors. It prioritizes intent and contextual meaning over literal term matching, optimized specifically for English documents and queries on the Elastic platform."}))),(0,m.jsx)(t.EuiSpacer,{size:"s"}),(0,m.jsx)("p",null,(0,m.jsx)(t.EuiLink,{href:n.links.ml.nlpElser,external:!0,target:"_blank"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",defaultMessage:"View documentation"}))),(0,m.jsx)(t.EuiSpacer,{size:"m"})):null,"e5"===e?(0,m.jsx)("div",null,(0,m.jsx)(t.EuiTitle,{size:"s"},(0,m.jsx)("h3",null,(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.e5Title",defaultMessage:"E5 (EmbEddings from bidirEctional Encoder rEpresentations)"}))),(0,m.jsx)(t.EuiSpacer,{size:"s"}),(0,m.jsx)("p",null,(0,m.jsx)(t.EuiText,{color:"subdued",size:"s"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.e5Description",defaultMessage:"E5 is a third party NLP model that enables you to perform multi-lingual semantic search by using dense vector representations. This model performs best for non-English language documents and queries."})," ",l[0].disclaimer)),(0,m.jsx)(t.EuiSpacer,{size:"s"}),(0,m.jsx)(t.EuiFlexGroup,{justifyContent:"spaceBetween",gutterSize:"none"},(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiLink,{href:n.links.ml.nlpE5,external:!0,target:"_blank"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.elserViewDocumentationLinkLabel",defaultMessage:"View documentation"})))),(0,m.jsx)(t.EuiSpacer,{size:"l"})):null,(0,m.jsx)(t.EuiFormFieldset,{legend:{children:(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.chooseModelLabel",defaultMessage:"Choose a model"})}},l.map(((s,o)=>(0,m.jsx)(a().Fragment,{key:s.model_id},(0,m.jsx)(t.EuiCheckableCard,{id:s.model_id,label:(0,m.jsx)(t.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"spaceBetween","data-test-subj":"mlAddTrainedModelFlyoutChooseModelPanels"},(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)("header",null,(0,m.jsx)(t.EuiText,{size:"s"},(0,m.jsx)("b",null,"Linux"===s.os&&"amd64"===s.arch?(0,m.jsx)("div",{"data-test-subj":`mlAddTrainedModelFlyoutModelPanel-${e}-${s.model_id}`},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.intelLinuxLabel",defaultMessage:"Intel and Linux optimized"})):(0,m.jsx)("div",{"data-test-subj":`mlAddTrainedModelFlyoutModelPanel-${e}-${s.model_id}`},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.crossPlatformLabel",defaultMessage:"Cross platform"}))))),(0,m.jsx)(t.EuiText,{size:"s",color:"subdued"},s.model_id)),(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},s.recommended?(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiToolTip,{content:(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.recommendedDownloadContent",defaultMessage:"Recommended model version for your cluster's hardware configuration"})},(0,m.jsx)(t.EuiBadge,{color:"hollow"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.recommendedDownloadLabel",defaultMessage:"Recommended"})))):null,s.licenseUrl&&s.softwareLicense?(0,m.jsx)(t.EuiFlexItem,{grow:!1},(0,m.jsx)(t.EuiBadge,{color:"hollow",target:"_blank",href:s.licenseUrl},"MIT"===s.softwareLicense?(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.modelsList.mitLicenseLabel",defaultMessage:"License: MIT"}):null)):null))),name:s.model_id,value:s.model_id,checked:s.model_id===u,onChange:x.bind(null,s.model_id)}),o<l.length-1?(0,m.jsx)(t.EuiSpacer,{size:"m"}):null)))),(0,m.jsx)(t.EuiSpacer,{size:"xxl"})))),(0,m.jsx)(t.EuiButton,{onClick:l.bind(null,u),fill:!0,disabled:!u,"data-test-subj":"mlAddTrainedModelFlyoutDownloadButton"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.ml.trainedModels.addModelFlyout.downloadButtonLabel",defaultMessage:"Download"})))},j=()=>{const{services:{docLinks:e}}=(0,r.hk)();return(0,m.jsx)(x,{supportedNlpModels:e.links.enterpriseSearch.supportedNlpModels,nlpImportModel:e.links.ml.nlpImportModel})}}}]);