"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_IN_SINGLE_METRIC_VIEWER_ACTION = void 0;
exports.createOpenInSingleMetricViewerAction = createOpenInSingleMetricViewerAction;
exports.isSingleMetricViewerEmbeddableContext = isSingleMetricViewerEmbeddableContext;
var _i18n = require("@kbn/i18n");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _locator = require("../../common/constants/locator");
var _embeddables = require("../embeddables");
var _get_embeddable_time_range = require("./get_embeddable_time_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_IN_SINGLE_METRIC_VIEWER_ACTION = exports.OPEN_IN_SINGLE_METRIC_VIEWER_ACTION = 'openInSingleMetricViewerAction';
function isSingleMetricViewerEmbeddableContext(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['embeddable']) && (0, _presentationPublishing.apiIsOfType)(arg.embeddable, _embeddables.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE);
}
function createOpenInSingleMetricViewerAction(getStartServices) {
  return {
    id: 'open-in-single-metric-viewer',
    type: OPEN_IN_SINGLE_METRIC_VIEWER_ACTION,
    order: 100,
    getIconType() {
      return 'singleMetricViewer';
    },
    getDisplayName() {
      return _i18n.i18n.translate('xpack.ml.actions.openInSingleMetricViewerTitle', {
        defaultMessage: 'Open in Single Metric Viewer'
      });
    },
    async getHref(context) {
      const [, pluginsStart] = await getStartServices();
      const locator = pluginsStart.share.url.locators.get(_locator.ML_APP_LOCATOR);
      if (isSingleMetricViewerEmbeddableContext(context)) {
        const {
          embeddable
        } = context;
        const {
          forecastId,
          jobIds,
          selectedEntities,
          selectedDetectorIndex
        } = embeddable;
        return locator.getUrl({
          page: _locator.ML_PAGES.SINGLE_METRIC_VIEWER,
          // @ts-ignore entities is not compatible with SerializableRecord
          pageState: {
            timeRange: (0, _get_embeddable_time_range.getEmbeddableTimeRange)(embeddable),
            refreshInterval: {
              display: 'Off',
              pause: true,
              value: 0
            },
            jobIds: jobIds.getValue(),
            query: {},
            entities: selectedEntities === null || selectedEntities === void 0 ? void 0 : selectedEntities.getValue(),
            detectorIndex: selectedDetectorIndex === null || selectedDetectorIndex === void 0 ? void 0 : selectedDetectorIndex.getValue(),
            forecastId: forecastId === null || forecastId === void 0 ? void 0 : forecastId.getValue()
          }
        }, {
          absolute: true
        });
      }
    },
    async execute(context) {
      if (!isSingleMetricViewerEmbeddableContext(context)) {
        throw new _public.IncompatibleActionError();
      }
      const [{
        application
      }] = await getStartServices();
      const singleMetricViewerUrl = await this.getHref(context);
      if (singleMetricViewerUrl !== undefined) {
        await application.navigateToUrl(singleMetricViewerUrl);
      }
    },
    async isCompatible(context) {
      return isSingleMetricViewerEmbeddableContext(context);
    }
  };
}