"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewTabContent = exports.LABELS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _serverless_context = require("../../contexts/ml/serverless_context");
var _kibana = require("../../contexts/kibana");
var _flyout = require("./flyout");
var _data_views_table = require("./data_views_table");
var _supplied_configurations = require("../supplied_configurations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LABELS = exports.LABELS = {
  dashboard: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dashboardLabel",
    defaultMessage: "Dashboard"
  }),
  jobs: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.jobsLabel",
    defaultMessage: "Jobs"
  }),
  search: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.searchLabel",
    defaultMessage: "Search"
  }),
  visualization: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.visualizationLabel",
    defaultMessage: "Visualization"
  })
};
const ListDescriptionItem = ({
  label,
  onClick,
  value
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, label ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  color: 'text',
  onClick: onClick
}, LABELS[label]) : '', label ? ' ' : '', /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
  size: label ? 's' : 'm',
  color: "subdued"
}, value)), label ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}));
const OverviewTabContent = ({
  module,
  setSelectedTabId,
  setSelectedKibanaSubTab
}) => {
  var _module$tags;
  const [runningDataRecognizer, setRunningDataRecognizer] = (0, _react.useState)(false);
  const [recognizerWasRun, setRecognizerWasRun] = (0, _react.useState)(false);
  const [matchingDataViews, setMatchingDataViews] = (0, _react.useState)([]);
  const {
    services: {
      docLinks,
      mlServices: {
        mlApi: {
          recognizeModule
        }
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const logsConfigsUrl = docLinks.links.ml.logsAnomalyDetectionConfigs;
  const metricsConfigsUrl = docLinks.links.ml.metricsAnomalyDetectionConfigs;
  const canCreateJob = (0, _check_capabilities.usePermissionCheck)('canCreateJob');
  const {
    showLogsSuppliedConfigurationsInfo
  } = (0, _serverless_context.useEnabledFeatures)();
  const runDataRecongizer = async () => {
    setRunningDataRecognizer(true);
    const result = await recognizeModule({
      moduleId: module.id
    });
    setMatchingDataViews(result);
    setRunningDataRecognizer(false);
    setRecognizerWasRun(true);
  };
  const runRecognizerButton = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    isDisabled: runningDataRecognizer || canCreateJob === false,
    isLoading: runningDataRecognizer,
    color: 'primary',
    onClick: runDataRecongizer,
    size: "s",
    "data-test-subj": "mlSuppliedConfigurationsFlyoutRunDataRecognizerButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.runDataRecognizerButtonLabel",
    defaultMessage: "Run data recognizer"
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      padding: `0 ${euiTheme.size.m}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, module.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      padding: `0 ${euiTheme.size.m}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.assetsTitle",
    defaultMessage: "Assets"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
    label: "jobs",
    value: module.jobs.length,
    onClick: () => setSelectedTabId(_flyout.TAB_IDS.JOBS)
  }), module.kibana ? Object.keys(module.kibana).map(kibanaAsset => {
    var _ref, _module$kibana$kibana;
    return /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
      label: kibanaAsset,
      onClick: () => {
        setSelectedKibanaSubTab(kibanaAsset);
        setSelectedTabId(_flyout.TAB_IDS.KIBANA);
      },
      value: (_ref = module.kibana && ((_module$kibana$kibana = module.kibana[kibanaAsset]) === null || _module$kibana$kibana === void 0 ? void 0 : _module$kibana$kibana.length)) !== null && _ref !== void 0 ? _ref : 0
    });
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.tagsTitle",
    defaultMessage: "Tags"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), (_module$tags = module.tags) !== null && _module$tags !== void 0 && _module$tags.length ? module.tags.map(tag => /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
    value: tag
  })) : /*#__PURE__*/_react.default.createElement(ListDescriptionItem, {
    value: _i18n.i18n.translate('xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.noTagsLabel', {
      defaultMessage: 'No tags'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.typeTitle",
    defaultMessage: "Type"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, module.type))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, module.query !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    rowGutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.eligibleTitle",
    defaultMessage: "These jobs are available if data exists that match the following query:"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    isCopyable: true,
    overflowHeight: "500px",
    "data-test-subj": "mlPreconfigJobsQueryBlock"
  }, JSON.stringify(module.query, null, 2)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), module.query !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dataRecognizerHelpButtonLabel",
    defaultMessage: "Check data views to determine which can be used to create jobs with this configuration."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, canCreateJob === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: (0, _check_capabilities.createPermissionFailureMessage)('canCreateJob')
  }, runRecognizerButton) : runRecognizerButton))) : null, recognizerWasRun ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_data_views_table.DataViewsTable, {
    matchingDataViews: matchingDataViews,
    moduleId: module.id,
    jobsLength: module.jobs.length
  })) : null) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      margin: euiTheme.size.s
    },
    color: "primary",
    iconType: (0, _supplied_configurations.isLogoObject)(module.logo) ? module.logo.icon : undefined,
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.unableToUseModuleTitle",
      defaultMessage: "You cannot create these jobs here"
    })),
    body: showLogsSuppliedConfigurationsInfo === true ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.unableToUseModuleHelpMessage",
      defaultMessage: "These supplied configurations can be used in {appName}.",
      values: {
        appName: module.type
      }
    })) : undefined,
    footer: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.useInanotherAppTitle",
      defaultMessage: "Want to learn more?"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: module.type === 'Logs' ? logsConfigsUrl : metricsConfigsUrl,
      target: "_blank"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.useInanotherAppLink",
      defaultMessage: "Refer to the docs for more information on how to use this supplied configuration in other apps"
    })))
  })))));
};
exports.OverviewTabContent = OverviewTabContent;