"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewsTable = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../contexts/kibana");
var _locator = require("../../../../common/constants/locator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataViewsTable = ({
  matchingDataViews,
  moduleId,
  jobsLength
}) => {
  const {
    services: {
      application: {
        navigateToUrl
      }
    }
  } = (0, _kibana.useMlKibana)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const getUrl = (0, _react.useCallback)(async id => {
    return await mlLocator.getUrl({
      page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_RECOGNIZER,
      pageState: {
        id: moduleId,
        index: id
      }
    });
  }, [mlLocator, moduleId]);
  const columns = [{
    field: 'title',
    name: _i18n.i18n.translate('xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dataViewMatches.dataViewTitleColumnName', {
      defaultMessage: 'Title'
    }),
    sortable: true,
    truncateText: true
  }, {
    field: 'name',
    name: _i18n.i18n.translate('xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dataViewMatches.dataViewNameColumnName', {
      defaultMessage: 'Name'
    }),
    sortable: true,
    truncateText: true
  }, {
    name: _i18n.i18n.translate('xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dataViewMatches.actionsColumnName', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      render: dataViewInfo => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          isDisabled: false,
          color: 'primary',
          onClick: async () => {
            const url = await getUrl(dataViewInfo.id);
            navigateToUrl(url);
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.anomalyDetection.suppliedConfigurationsFlyout.dataViewMatches.createJobAction",
          defaultMessage: "Create {jobsLength, plural, one {# job} other {# jobs}}",
          values: {
            jobsLength
          }
        }));
      },
      'data-test-subj': 'mlSuppliedConfigurationsFlyoutActionCreate'
    }],
    'data-test-subj': 'mlSuppliedConfigurationsFlyoutColumnActions'
  }];
  const sorting = {
    sort: {
      field: 'title',
      direction: 'desc'
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "mlSuppliedConfigurationsFlyoutDataViewsTable",
    items: matchingDataViews,
    columns: columns,
    rowProps: item => ({
      'data-test-subj': `mlSuppliedConfigurationsDataViewsTableRow row-${item.id}`
    }),
    pagination: true,
    sorting: sorting
  });
};
exports.DataViewsTable = DataViewsTable;