"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatafeedPreviewPane = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ml = require("../../../../contexts/ml");
var _job_utils = require("../../../../../../common/util/job_utils");
var _kibana = require("../../../../contexts/kibana");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _ml_job_editor = require("../ml_job_editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatafeedPreviewPane = ({
  job
}) => {
  const {
    jobs: {
      datafeedPreview
    }
  } = (0, _kibana.useMlApi)();
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const canPreviewDatafeed = (0, _check_capabilities.usePermissionCheck)('canPreviewDatafeed');
  const [loading, setLoading] = (0, _react.useState)(false);
  const [previewJson, setPreviewJson] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    setLoading(true);
    datafeedPreview(job.datafeed_config.datafeed_id).then(resp => {
      if (Array.isArray(resp)) {
        if (resp.length === 0) {
          setPreviewJson(null);
        } else {
          setPreviewJson(JSON.stringify(resp.slice(0, _job_utils.ML_DATA_PREVIEW_COUNT), null, 2));
        }
      } else {
        setPreviewJson('');
      }
      setLoading(false);
    });
  }, [datafeedPreview, job]);
  if (canPreviewDatafeed === false) {
    return /*#__PURE__*/_react.default.createElement(InsufficientPermissions, null);
  }
  return loading ? /*#__PURE__*/_react.default.createElement("div", {
    className: "job-loading-spinner",
    "data-test-subj": "mlJobDetails loading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, previewJson === null ? /*#__PURE__*/_react.default.createElement(EmptyResults, {
    showFrozenTierText: showNodeInfo === true
  }) : /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: previewJson,
    readOnly: true
  }));
};
exports.DatafeedPreviewPane = DatafeedPreviewPane;
const InsufficientPermissions = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.jobDetails.noPermissionToViewDatafeedPreviewTitle",
    defaultMessage: "You do not have permission to view the datafeed preview"
  }),
  color: "warning",
  iconType: "warning"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.jobsList.jobDetails.pleaseContactYourAdministratorLabel",
  defaultMessage: "Please contact your administrator"
})));
const EmptyResults = ({
  showFrozenTierText
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobsList.jobDetails.noResults.title",
    defaultMessage: "No results"
  }),
  color: "warning",
  iconType: "warning"
}, showFrozenTierText ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.jobsList.jobDetails.noResults.text",
  defaultMessage: "Note: Datafeed preview does not return results from frozen tiers."
})) : null);