"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerAnomaliesContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _explorer_charts_container = require("./explorer_charts_container");
var _select_severity = require("../../components/controls/select_severity/select_severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tooManyBucketsCalloutMsg = _i18n.i18n.translate('xpack.ml.explorer.charts.dashboardTooManyBucketsDescription', {
  defaultMessage: 'This selection contains too many buckets to be displayed. You should shorten the time range of the view.'
});
const ExplorerAnomaliesContainer = ({
  id,
  chartsData,
  showCharts,
  severity,
  setSeverity,
  mlLocator,
  tableData,
  timeBuckets,
  timefilter,
  onSelectEntity,
  showSelectedInterval,
  chartsService,
  timeRange,
  showFilterIcons
}) => {
  return (
    /*#__PURE__*/
    // TODO: Remove data-shared-item and data-rendering-count as part of https://github.com/elastic/kibana/issues/179376
    // These attributes are temporarily needed for reporting to not have any warning
    _react.default.createElement("div", {
      "data-shared-item": "",
      "data-rendering-count": 1
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      id: id,
      direction: "row",
      gutterSize: "l",
      responsive: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_select_severity.SelectSeverityUI, {
      severity: severity,
      onChange: setSeverity
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), Array.isArray(chartsData.seriesToPlot) && chartsData.seriesToPlot.length === 0 && chartsData.errorMessages === undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: 'center',
      "data-test-subj": 'mlNoMatchingAnomaliesMessage'
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.noMatchingAnomaliesFoundTitle",
      defaultMessage: "No matching anomalies found"
    }))), showCharts && /*#__PURE__*/_react.default.createElement(_explorer_charts_container.ExplorerChartsContainer, (0, _extends2.default)({}, chartsData, {
      isEmbeddable: true,
      severity: severity.val,
      mlLocator,
      tableData,
      timeBuckets,
      timefilter,
      timeRange,
      onSelectEntity,
      tooManyBucketsCalloutMsg,
      showSelectedInterval,
      chartsService,
      id,
      showFilterIcons
    })))
  );
};
exports.ExplorerAnomaliesContainer = ExplorerAnomaliesContainer;