"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsIdSelectorControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _job_details_flyout_context = require("../../../../jobs/components/job_details_flyout/job_details_flyout_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectorControl = ({
  analyticsId,
  'data-test-subj': dataTestSubj
}) => {
  const {
    setActiveJobId,
    setActiveFlyout
  } = (0, _job_details_flyout_context.useJobInfoFlyouts)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const panels = (0, _react.useMemo)(() => {
    return [{
      id: 0,
      items: [{
        name: _i18n.i18n.translate('xpack.ml.overview.dataFrameAnalytics.jobContextMenu.details', {
          defaultMessage: 'Job details'
        }),
        icon: 'eye',
        onClick: () => {
          setActiveJobId(analyticsId);
          setActiveFlyout(_job_details_flyout_context.FlyoutType.DATA_FRAME_ANALYTICS_DETAILS);
          closePopover();
        }
      }]
    }];
  }, [analyticsId, closePopover, setActiveFlyout, setActiveJobId]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": dataTestSubj,
    iconType: "boxesVertical",
    iconSide: "right",
    onClick: setIsPopoverOpen.bind(null, true),
    size: "s",
    color: "text"
  }, analyticsId);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `mlAnalyticsDetailsPopover ${analyticsId}`,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
};
const AnalyticsIdSelectorControls = ({
  setIsIdSelectorFlyoutVisible,
  selectedId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, selectedId ? /*#__PURE__*/_react.default.createElement(SelectorControl, {
    key: `${selectedId}-id`,
    "data-test-subj": `mlAnalyticsIdSelectionBadge ${selectedId}`,
    analyticsId: selectedId
  }) : null, !selectedId ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.noIdsSelectedLabel",
    defaultMessage: "No Analytics ID selected"
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "pencil",
    onClick: setIsIdSelectorFlyoutVisible.bind(null, true),
    "data-test-subj": "mlButtonEditAnalyticsIdSelection"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.editSelection",
    defaultMessage: "Edit selection"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null));
};
exports.AnalyticsIdSelectorControls = AnalyticsIdSelectorControls;