"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToFilterListLink = AddToFilterListLink;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for quick addition of a partitioning field value
 * to a filter list used in the scope part of a rule.
 */

function AddToFilterListLink({
  fieldValue,
  filterId,
  addItemToFilterList
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => addItemToFilterList(fieldValue, filterId, true),
    "data-test-subj": "mlAddToFilterListLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.ruleEditor.addValueToFilterListLinkText",
    defaultMessage: "Add {fieldValue} to {filterId}",
    values: {
      fieldValue,
      filterId
    }
  }));
}
AddToFilterListLink.propTypes = {
  fieldValue: _propTypes.default.string.isRequired,
  filterId: _propTypes.default.string.isRequired,
  addItemToFilterList: _propTypes.default.func.isRequired
};