"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSideNavItems = useSideNavItems;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _mlUrlState = require("@kbn/ml-url-state");
var _notifications_indicator = require("./notifications_indicator");
var _kibana = require("../../contexts/kibana");
var _license = require("../../license");
var _locator = require("../../../../common/constants/locator");
var _check_capabilities = require("../../capabilities/check_capabilities");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSideNavItems(activeRoute) {
  const mlLocator = (0, _kibana.useMlLocator)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const mlFeaturesDisabled = !(0, _license.isFullLicense)();
  const canViewMlNodes = (0, _check_capabilities.usePermissionCheck)('canViewMlNodes');
  const [canUseAiops] = (0, _check_capabilities.usePermissionCheck)(['canUseAiops']);
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const pageState = (0, _react.useMemo)(() => {
    return (globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval) !== undefined ? {
      globalState: {
        refreshInterval: globalState.refreshInterval
      }
    } : undefined;
  }, [globalState === null || globalState === void 0 ? void 0 : globalState.refreshInterval]);
  const redirectToTab = (0, _react.useCallback)(async defaultPathId => {
    const path = await mlLocator.getUrl({
      page: defaultPathId,
      // only retain the refreshInterval part of globalState
      // appState will not be considered.
      pageState
    });
    await navigateToPath(path, false);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [pageState]);
  const tabsDefinition = (0, _react.useMemo)(() => {
    const disableLinks = mlFeaturesDisabled;
    const mlTabs = [{
      id: 'main_section',
      name: '',
      items: [{
        id: 'overview',
        pathId: _locator.ML_PAGES.OVERVIEW,
        name: _i18n.i18n.translate('xpack.ml.navMenu.overviewTabLinkText', {
          defaultMessage: 'Overview'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab overview'
      }, {
        id: 'notifications',
        pathId: _locator.ML_PAGES.NOTIFICATIONS,
        name: disableLinks ? _i18n.i18n.translate('xpack.ml.navMenu.notificationsTabLinkText', {
          defaultMessage: 'Notifications'
        }) : /*#__PURE__*/_react.default.createElement(_notifications_indicator.NotificationsIndicator, null),
        disabled: disableLinks,
        testSubj: 'mlMainTab notifications'
      }, {
        id: 'memory_usage',
        pathId: _locator.ML_PAGES.MEMORY_USAGE,
        name: _i18n.i18n.translate('xpack.ml.navMenu.memoryUsageText', {
          defaultMessage: 'Memory Usage'
        }),
        disabled: disableLinks || !canViewMlNodes,
        testSubj: 'mlMainTab nodesOverview'
      }]
    }, {
      id: 'anomaly_detection_section',
      name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetectionTabLinkText', {
        defaultMessage: 'Anomaly Detection'
      }),
      disabled: disableLinks,
      items: [{
        id: 'anomaly_detection',
        name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetection.jobsManagementText', {
          defaultMessage: 'Jobs'
        }),
        disabled: disableLinks,
        pathId: _locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE,
        testSubj: 'mlMainTab anomalyDetection'
      }, {
        id: 'anomaly_explorer',
        name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetection.anomalyExplorerText', {
          defaultMessage: 'Anomaly Explorer'
        }),
        disabled: disableLinks,
        pathId: _locator.ML_PAGES.ANOMALY_EXPLORER,
        testSubj: 'mlMainTab anomalyExplorer'
      }, {
        id: 'single_metric_viewer',
        name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetection.singleMetricViewerText', {
          defaultMessage: 'Single Metric Viewer'
        }),
        pathId: _locator.ML_PAGES.SINGLE_METRIC_VIEWER,
        disabled: disableLinks,
        testSubj: 'mlMainTab singleMetricViewer'
      }, {
        id: 'settings',
        pathId: _locator.ML_PAGES.SETTINGS,
        name: _i18n.i18n.translate('xpack.ml.navMenu.settingsTabLinkText', {
          defaultMessage: 'Settings'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab settings',
        highlightNestedRoutes: true
      }, {
        id: 'supplied_cofigurations',
        name: _i18n.i18n.translate('xpack.ml.navMenu.anomalyDetection.suppliedConfigurationsLinkText', {
          defaultMessage: 'Supplied Configurations'
        }),
        disabled: disableLinks,
        pathId: _locator.ML_PAGES.SUPPLIED_CONFIGURATIONS,
        testSubj: 'mlMainTab suppliedConfigurations'
      }]
    }, {
      id: 'data_frame_analytics_section',
      name: _i18n.i18n.translate('xpack.ml.navMenu.dataFrameAnalyticsTabLinkText', {
        defaultMessage: 'Data Frame Analytics'
      }),
      disabled: disableLinks,
      items: [{
        id: 'data_frame_analytics_jobs',
        pathId: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE,
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataFrameAnalytics.jobsManagementText', {
          defaultMessage: 'Jobs'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab dataFrameAnalytics'
      }, {
        id: 'data_frame_analytics_results_explorer',
        pathId: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_EXPLORATION,
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataFrameAnalytics.resultsExplorerText', {
          defaultMessage: 'Results Explorer'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab dataFrameAnalyticsResultsExplorer'
      }, {
        id: 'data_frame_analytics_job_map',
        pathId: _locator.ML_PAGES.DATA_FRAME_ANALYTICS_MAP,
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataFrameAnalytics.analyticsMapText', {
          defaultMessage: 'Analytics Map'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab dataFrameAnalyticsMap'
      }]
    }, {
      id: 'model_management',
      name: _i18n.i18n.translate('xpack.ml.navMenu.modelManagementText', {
        defaultMessage: 'Model Management'
      }),
      disabled: disableLinks,
      items: [{
        id: 'trained_models',
        pathId: _locator.ML_PAGES.TRAINED_MODELS_MANAGE,
        name: _i18n.i18n.translate('xpack.ml.navMenu.trainedModelsText', {
          defaultMessage: 'Trained Models'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab trainedModels'
      }]
    }, {
      id: 'datavisualizer',
      name: _i18n.i18n.translate('xpack.ml.navMenu.dataVisualizerTabLinkText', {
        defaultMessage: 'Data Visualizer'
      }),
      disabled: false,
      pathId: _locator.ML_PAGES.DATA_VISUALIZER,
      testSubj: 'mlMainTab dataVisualizer',
      items: [{
        id: 'filedatavisualizer',
        pathId: _locator.ML_PAGES.DATA_VISUALIZER_FILE,
        name: _i18n.i18n.translate('xpack.ml.navMenu.fileDataVisualizerLinkText', {
          defaultMessage: 'File'
        }),
        disabled: false,
        testSubj: 'mlMainTab fileDataVisualizer'
      }, {
        id: 'data_view_datavisualizer',
        pathId: _locator.ML_PAGES.DATA_VISUALIZER_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataViewDataVisualizerLinkText', {
          defaultMessage: 'Data View'
        }),
        disabled: false,
        testSubj: 'mlMainTab indexDataVisualizer',
        relatedRouteIds: ['data_view_datavisualizer']
      }, {
        id: 'esql_datavisualizer',
        pathId: _locator.ML_PAGES.DATA_VISUALIZER_ESQL,
        name: _i18n.i18n.translate('xpack.ml.navMenu.esqlDataVisualizerLinkText', {
          defaultMessage: 'ES|QL'
        }),
        disabled: false,
        testSubj: 'mlMainTab esqlDataVisualizer',
        relatedRouteIds: ['data_view_datavisualizer_esql']
      }, {
        id: 'data_drift',
        pathId: _locator.ML_PAGES.DATA_DRIFT_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.dataComparisonText', {
          defaultMessage: 'Data Drift'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab dataDrift',
        relatedRouteIds: ['data_drift']
      }]
    }];
    if (canUseAiops === false) {
      return mlTabs;
    }
    mlTabs.push({
      id: 'aiops_section',
      name: _i18n.i18n.translate('xpack.ml.navMenu.aiopsTabLinkText', {
        defaultMessage: 'AIOps Labs'
      }),
      disabled: disableLinks,
      items: [{
        id: 'logRateAnalysis',
        pathId: _locator.ML_PAGES.AIOPS_LOG_RATE_ANALYSIS_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.logRateAnalysisLinkText', {
          defaultMessage: 'Log Rate Analysis'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab logRateAnalysis',
        relatedRouteIds: ['log_rate_analysis']
      }, {
        id: 'logCategorization',
        pathId: _locator.ML_PAGES.AIOPS_LOG_CATEGORIZATION_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.logCategorizationLinkText', {
          defaultMessage: 'Log Pattern Analysis'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab logCategorization',
        relatedRouteIds: ['log_categorization']
      }, ...(_constants.CHANGE_POINT_DETECTION_ENABLED ? [{
        id: 'changePointDetection',
        pathId: _locator.ML_PAGES.AIOPS_CHANGE_POINT_DETECTION_INDEX_SELECT,
        name: _i18n.i18n.translate('xpack.ml.navMenu.changePointDetectionLinkText', {
          defaultMessage: 'Change Point Detection'
        }),
        disabled: disableLinks,
        testSubj: 'mlMainTab changePointDetection',
        relatedRouteIds: ['change_point_detection']
      }] : [])]
    });
    return mlTabs;
  }, [mlFeaturesDisabled, canViewMlNodes, canUseAiops]);
  const getTabItem = (0, _react.useCallback)(tab => {
    const {
      id,
      disabled,
      items,
      onClick,
      pathId,
      name,
      testSubj,
      highlightNestedRoutes,
      relatedRouteIds
    } = tab;
    const onClickCallback = onClick !== null && onClick !== void 0 ? onClick : pathId ? redirectToTab.bind(null, pathId) : undefined;
    const isSelected = `/${pathId}` === (activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path) || !!highlightNestedRoutes && (activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.path.includes(`${pathId}/`)) || Array.isArray(relatedRouteIds) && relatedRouteIds.includes(activeRoute === null || activeRoute === void 0 ? void 0 : activeRoute.id);
    return {
      id,
      name,
      isSelected,
      disabled,
      ...(onClickCallback ? {
        onClick: onClickCallback
      } : {}),
      'data-test-subj': testSubj + (isSelected ? ' selected' : ''),
      items: items ? items.map(getTabItem) : undefined,
      forceOpen: true
    };
  }, [activeRoute, redirectToTab]);
  return (0, _react.useMemo)(() => tabsDefinition.map(getTabItem), [tabsDefinition, getTabItem]);
}