"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSignificantItem = isSignificantItem;
exports.isSignificantItemGroup = isSignificantItemGroup;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Type guard for a significant item.
 * Note this is used as a custom type within Log Rate Analysis
 * for a p-value based variant, not a generic significant terms
 * aggregation type.
 * @param arg The unknown type to be evaluated
 * @returns Return whether arg is of type SignificantItem
 */
function isSignificantItem(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['key', 'type', 'fieldName', 'fieldValue', 'doc_count', 'bg_count', 'total_doc_count', 'total_bg_count', 'score', 'pValue', 'normalizedScore']);
}
/**
 * Type guard to check if the given argument is a SignificantItemGroup.
 * @param arg The unknown type to be evaluated
 * @returns Return whether arg is of type SignificantItemGroup
 */
function isSignificantItemGroup(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['id', 'group', 'docCount', 'pValue']);
}