"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.memory = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
var _constants = require("../../../shared/charts/constants");
var _formulas$memoryUsage, _formulas$memoryFree$, _formulas$memoryUsage2;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const memoryUsageBreakdown = {
  id: 'memoryUsageBreakdown',
  chartType: 'xy',
  title: _constants.MEMORY_USAGE_LABEL,
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [{
      ..._formulas.formulas.memoryCache,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.cache', {
        defaultMessage: 'Cache'
      })
    }, {
      ..._formulas.formulas.memoryUsed,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.used', {
        defaultMessage: 'Used'
      })
    }, {
      ..._formulas.formulas.memoryFreeExcludingCache,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.free', {
        defaultMessage: 'Free'
      })
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const memoryUsageXY = {
  id: 'memoryUsage',
  chartType: 'xy',
  title: (_formulas$memoryUsage = _formulas.formulas.memoryUsage.label) !== null && _formulas$memoryUsage !== void 0 ? _formulas$memoryUsage : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.memoryUsage]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_YBOUNDS,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const memoryFree = {
  id: 'memoryFree',
  chartType: 'xy',
  title: (_formulas$memoryFree$ = _formulas.formulas.memoryFree.label) !== null && _formulas$memoryFree$ !== void 0 ? _formulas$memoryFree$ : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.memoryFree]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const memoryUsageMetric = {
  id: 'memoryUsage',
  chartType: 'metric',
  title: (_formulas$memoryUsage2 = _formulas.formulas.memoryUsage.label) !== null && _formulas$memoryUsage2 !== void 0 ? _formulas$memoryUsage2 : '',
  trendLine: true,
  ..._formulas.formulas.memoryUsage
};
const memory = exports.memory = {
  xy: {
    memoryUsageBreakdown,
    memoryUsage: memoryUsageXY,
    memoryFree
  },
  metric: {
    memoryUsage: memoryUsageMetric
  }
};