"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOCEntry = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _toc_entry_actions_popover = require("./toc_entry_actions_popover");
var _action_labels = require("./action_labels");
var _legend_details = require("./legend_details");
var _layer_group = require("../../../../../classes/layers/layer_group");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function escapeLayerName(name) {
  return name.split(' ').join('_');
}
class TOCEntry extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      displayName: '',
      hasLegendDetails: false,
      shouldShowModal: false,
      supportsFitToBounds: false
    });
    (0, _defineProperty2.default)(this, "_toggleLayerDetailsVisibility", () => {
      if (this.props.isLegendDetailsOpen) {
        this.props.hideTOCDetails(this.props.layer.getId());
      } else {
        this.props.showTOCDetails(this.props.layer.getId());
      }
    });
    (0, _defineProperty2.default)(this, "_openLayerPanelWithCheck", () => {
      const {
        selectedLayer,
        hasDirtyStateSelector
      } = this.props;
      if (selectedLayer && selectedLayer.getId() === this.props.layer.getId()) {
        return;
      }
      if (hasDirtyStateSelector) {
        this.setState({
          shouldShowModal: true
        });
        return;
      }
      this.props.openLayerPanel(this.props.layer.getId());
    });
    (0, _defineProperty2.default)(this, "_fitToBounds", () => {
      this.props.fitToBounds(this.props.layer.getId());
    });
    (0, _defineProperty2.default)(this, "_toggleVisible", () => {
      this.props.toggleVisible(this.props.layer.getId());
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._updateDisplayName();
    this._loadHasLegendDetails();
    this._loadSupportsFitToBounds();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidUpdate() {
    this._updateDisplayName();
    this._loadHasLegendDetails();
  }
  async _loadSupportsFitToBounds() {
    const supportsFitToBounds = await this.props.layer.supportsFitToBounds();
    if (this._isMounted) {
      this.setState({
        supportsFitToBounds
      });
    }
  }
  async _loadHasLegendDetails() {
    const hasLegendDetails = ((await this.props.layer.hasLegendDetails()) || this.props.layer.hasErrors() || this.props.layer.hasWarnings()) && this.props.layer.isVisible() && this.props.layer.showAtZoomLevel(this.props.zoom);
    if (this._isMounted && hasLegendDetails !== this.state.hasLegendDetails) {
      this.setState({
        hasLegendDetails
      });
    }
  }
  async _updateDisplayName() {
    const displayName = await this.props.layer.getDisplayName();
    if (this._isMounted && displayName !== this.state.displayName) {
      this.setState({
        displayName
      });
    }
  }
  _renderCancelModal() {
    if (!this.state.shouldShowModal) {
      return null;
    }
    const closeModal = () => {
      this.setState({
        shouldShowModal: false
      });
    };
    const openPanel = () => {
      closeModal();
      this.props.openLayerPanel(this.props.layer.getId());
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: "Discard changes",
      onCancel: closeModal,
      onConfirm: openPanel,
      cancelButtonText: "Do not proceed",
      confirmButtonText: "Proceed and discard changes",
      buttonColor: "danger",
      defaultFocusedButton: "cancel"
    }, /*#__PURE__*/_react.default.createElement("p", null, "There are unsaved changes to your layer."), /*#__PURE__*/_react.default.createElement("p", null, "Are you sure you want to proceed?"));
  }
  _renderQuickActions() {
    const quickActions = [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      key: "toggleVisiblity",
      iconType: (0, _action_labels.getVisibilityToggleIcon)(this.props.layer.isVisible()),
      title: (0, _action_labels.getVisibilityToggleLabel)(this.props.layer.isVisible()),
      "aria-label": (0, _action_labels.getVisibilityToggleLabel)(this.props.layer.isVisible()),
      onClick: this._toggleVisible
    })];
    if (this.state.supportsFitToBounds) {
      quickActions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        key: "fitToBounds",
        iconType: "expand",
        title: _action_labels.FIT_TO_DATA_LABEL,
        "aria-label": _action_labels.FIT_TO_DATA_LABEL,
        onClick: this._fitToBounds
      }));
    }
    if (!this.props.isReadOnly) {
      quickActions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        key: "settings",
        isDisabled: this.props.isEditButtonDisabled,
        iconType: "pencil",
        "aria-label": _action_labels.EDIT_LAYER_SETTINGS_LABEL,
        title: _action_labels.EDIT_LAYER_SETTINGS_LABEL,
        onClick: this._openLayerPanelWithCheck
      }));
      quickActions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
        key: "reorder",
        iconType: "grab",
        title: _i18n.i18n.translate('xpack.maps.layerControl.tocEntry.grabButtonTitle', {
          defaultMessage: 'Reorder layer'
        }),
        "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.tocEntry.grabButtonAriaLabel', {
          defaultMessage: 'Reorder layer'
        }),
        className: "mapTocEntry__grab"
      }, this.props.dragHandleProps)));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapTocEntry__layerIcons"
    }, quickActions);
  }
  _renderDetailsToggle() {
    if (this.props.isDragging || !this.state.hasLegendDetails) {
      return null;
    }
    const {
      isLegendDetailsOpen
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("span", {
      className: "mapTocEntry__detailsToggle"
    }, /*#__PURE__*/_react.default.createElement("button", {
      className: "mapTocEntry__detailsToggleButton",
      "aria-label": isLegendDetailsOpen ? _i18n.i18n.translate('xpack.maps.layerControl.tocEntry.hideDetailsButtonAriaLabel', {
        defaultMessage: 'Hide layer details'
      }) : _i18n.i18n.translate('xpack.maps.layerControl.tocEntry.showDetailsButtonAriaLabel', {
        defaultMessage: 'Show layer details'
      }),
      title: isLegendDetailsOpen ? _i18n.i18n.translate('xpack.maps.layerControl.tocEntry.hideDetailsButtonTitle', {
        defaultMessage: 'Hide layer details'
      }) : _i18n.i18n.translate('xpack.maps.layerControl.tocEntry.showDetailsButtonTitle', {
        defaultMessage: 'Show layer details'
      }),
      onClick: this._toggleLayerDetailsVisibility
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      className: "eui-alignBaseline",
      type: isLegendDetailsOpen ? 'arrowUp' : 'arrowDown',
      size: "s"
    })));
  }
  _renderLayerHeader() {
    const {
      layer,
      zoom
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: layer.isVisible() && layer.showAtZoomLevel(zoom) ? 'mapTocEntry-visible' : 'mapTocEntry-notVisible'
    }, /*#__PURE__*/_react.default.createElement(_toc_entry_actions_popover.TOCEntryActionsPopover, {
      layer: layer,
      displayName: this.state.displayName,
      escapedDisplayName: escapeLayerName(this.state.displayName),
      openLayerSettings: this._openLayerPanelWithCheck,
      isEditButtonDisabled: this.props.isEditButtonDisabled,
      supportsFitToBounds: this.state.supportsFitToBounds
    }), this._renderQuickActions());
  }
  _hightlightAsSelectedLayer() {
    if (this.props.isCombineLayer) {
      return false;
    }
    if (this.props.layer.isPreviewLayer()) {
      return true;
    }
    return this.props.selectedLayer && this.props.selectedLayer.getId() === this.props.layer.getId();
  }
  render() {
    const classes = (0, _classnames.default)('mapTocEntry', {
      'mapTocEntry-isDragging': this.props.isDragging,
      'mapTocEntry-isDraggingOver': this.props.isDraggingOver,
      'mapTocEntry-isCombineLayer': this.props.isCombineLayer,
      'mapTocEntry-isSelected': this._hightlightAsSelectedLayer(),
      'mapTocEntry-isInEditingMode': this.props.isFeatureEditorOpenForLayer
    });
    const depthStyle = this.props.depth > 0 ? {
      paddingLeft: `${8 + this.props.depth * 24}px`
    } : {};
    return /*#__PURE__*/_react.default.createElement("div", {
      style: depthStyle,
      className: classes,
      id: this.props.layer.getId(),
      "data-layerid": this.props.layer.getId()
    }, this._renderLayerHeader(), this.props.isLegendDetailsOpen && this.state.hasLegendDetails && !(0, _layer_group.isLayerGroup)(this.props.layer) ? /*#__PURE__*/_react.default.createElement("div", {
      className: "mapTocEntry__layerDetails",
      "data-test-subj": `mapLayerTOCDetails${escapeLayerName(this.state.displayName)}`
    }, /*#__PURE__*/_react.default.createElement(_legend_details.LegendDetails, {
      inspectorAdapters: this.props.inspectorAdapters,
      layer: this.props.layer
    })) : null, this._renderDetailsToggle(), this._renderCancelModal(), this.props.isFeatureEditorOpenForLayer && /*#__PURE__*/_react.default.createElement("div", {
      className: "mapTocEntry-isInEditingMode__row"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "vector",
      size: "s"
    }), /*#__PURE__*/_react.default.createElement("span", {
      className: "mapTocEntry-isInEditingMode__editFeatureText"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerControl.tocEntry.EditFeatures",
      defaultMessage: "Edit features"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      flush: "both",
      onClick: this.props.cancelEditing
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerControl.tocEntry.exitEditModeAriaLabel",
      defaultMessage: "Exit"
    }))));
  }
}
exports.TOCEntry = TOCEntry;