"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_FLYOUT = exports.SHOW_TOC_DETAILS = exports.SET_READ_ONLY = exports.SET_OPEN_TOC_DETAILS = exports.SET_IS_TIME_SLIDER_OPEN = exports.SET_IS_LAYER_TOC_OPEN = exports.SET_FULL_SCREEN = exports.SET_DRAW_MODE = exports.SET_AUTO_OPEN_WIZARD_ID = exports.PUSH_DELETED_FEATURE_ID = exports.HIDE_TOC_DETAILS = exports.CLEAR_DELETED_FEATURE_IDS = void 0;
exports.clearDeletedFeatureIds = clearDeletedFeatureIds;
exports.closeTimeslider = closeTimeslider;
exports.enableFullScreen = enableFullScreen;
exports.exitFullScreen = exitFullScreen;
exports.hideTOCDetails = hideTOCDetails;
exports.openMapSettings = openMapSettings;
exports.openTimeslider = openTimeslider;
exports.pushDeletedFeatureId = pushDeletedFeatureId;
exports.setAutoOpenLayerWizardId = setAutoOpenLayerWizardId;
exports.setDrawMode = setDrawMode;
exports.setIsLayerTOCOpen = setIsLayerTOCOpen;
exports.setOpenTOCDetails = setOpenTOCDetails;
exports.setReadOnly = setReadOnly;
exports.showTOCDetails = showTOCDetails;
exports.updateFlyout = updateFlyout;
var _ui_selectors = require("../selectors/ui_selectors");
var _ui = require("../reducers/ui");
var _map_actions = require("./map_actions");
var _layer_actions = require("./layer_actions");
var _constants = require("../../common/constants");
var _map_action_constants = require("./map_action_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UPDATE_FLYOUT = exports.UPDATE_FLYOUT = 'UPDATE_FLYOUT';
const SET_IS_LAYER_TOC_OPEN = exports.SET_IS_LAYER_TOC_OPEN = 'SET_IS_LAYER_TOC_OPEN';
const SET_IS_TIME_SLIDER_OPEN = exports.SET_IS_TIME_SLIDER_OPEN = 'SET_IS_TIME_SLIDER_OPEN';
const SET_FULL_SCREEN = exports.SET_FULL_SCREEN = 'SET_FULL_SCREEN';
const SET_READ_ONLY = exports.SET_READ_ONLY = 'SET_READ_ONLY';
const SET_OPEN_TOC_DETAILS = exports.SET_OPEN_TOC_DETAILS = 'SET_OPEN_TOC_DETAILS';
const SHOW_TOC_DETAILS = exports.SHOW_TOC_DETAILS = 'SHOW_TOC_DETAILS';
const HIDE_TOC_DETAILS = exports.HIDE_TOC_DETAILS = 'HIDE_TOC_DETAILS';
const SET_DRAW_MODE = exports.SET_DRAW_MODE = 'SET_DRAW_MODE';
const SET_AUTO_OPEN_WIZARD_ID = exports.SET_AUTO_OPEN_WIZARD_ID = 'SET_AUTO_OPEN_WIZARD_ID';
const PUSH_DELETED_FEATURE_ID = exports.PUSH_DELETED_FEATURE_ID = 'PUSH_DELETED_FEATURE_ID';
const CLEAR_DELETED_FEATURE_IDS = exports.CLEAR_DELETED_FEATURE_IDS = 'CLEAR_DELETED_FEATURE_IDS';
function exitFullScreen() {
  return {
    type: SET_FULL_SCREEN,
    isFullScreen: false
  };
}
function updateFlyout(display) {
  return {
    type: UPDATE_FLYOUT,
    display
  };
}
function openMapSettings() {
  return (dispatch, getState) => {
    const flyoutDisplay = (0, _ui_selectors.getFlyoutDisplay)(getState());
    if (flyoutDisplay === _ui.FLYOUT_STATE.MAP_SETTINGS_PANEL) {
      return;
    }
    dispatch((0, _layer_actions.setSelectedLayer)(null));
    dispatch((0, _map_actions.trackMapSettings)());
    dispatch(updateFlyout(_ui.FLYOUT_STATE.MAP_SETTINGS_PANEL));
  };
}
function setIsLayerTOCOpen(isLayerTOCOpen) {
  return {
    type: SET_IS_LAYER_TOC_OPEN,
    isLayerTOCOpen
  };
}
function enableFullScreen() {
  return {
    type: SET_FULL_SCREEN,
    isFullScreen: true
  };
}
function setReadOnly(isReadOnly) {
  return {
    type: SET_READ_ONLY,
    isReadOnly
  };
}
function setOpenTOCDetails(layerIds) {
  return {
    type: SET_OPEN_TOC_DETAILS,
    layerIds
  };
}
function showTOCDetails(layerId) {
  return (dispatch, getState) => {
    const openTOCDetails = (0, _ui_selectors.getOpenTOCDetails)(getState());
    if (openTOCDetails.includes(layerId)) {
      // details already open, nothing to do
      return;
    }
    dispatch({
      type: SHOW_TOC_DETAILS,
      layerId
    });
  };
}
function hideTOCDetails(layerId) {
  return {
    type: HIDE_TOC_DETAILS,
    layerId
  };
}
function setDrawMode(drawMode) {
  return dispatch => {
    if (drawMode === _constants.DRAW_MODE.NONE) {
      dispatch({
        type: _map_action_constants.UPDATE_EDIT_STATE,
        editState: undefined
      });
    }
    dispatch({
      type: SET_DRAW_MODE,
      drawMode
    });
  };
}
function openTimeslider() {
  return {
    type: SET_IS_TIME_SLIDER_OPEN,
    isTimesliderOpen: true
  };
}
function closeTimeslider() {
  return dispatch => {
    dispatch({
      type: SET_IS_TIME_SLIDER_OPEN,
      isTimesliderOpen: false
    });
    dispatch((0, _map_actions.setQuery)({
      clearTimeslice: true
    }));
  };
}
function setAutoOpenLayerWizardId(autoOpenLayerWizardId) {
  return dispatch => {
    dispatch((0, _layer_actions.setSelectedLayer)(null));
    dispatch(updateFlyout(_ui.FLYOUT_STATE.ADD_LAYER_WIZARD));
    dispatch(setDrawMode(_constants.DRAW_MODE.NONE));
    dispatch({
      type: SET_AUTO_OPEN_WIZARD_ID,
      autoOpenLayerWizardId
    });
  };
}
function pushDeletedFeatureId(featureId) {
  return {
    type: PUSH_DELETED_FEATURE_ID,
    featureId
  };
}
function clearDeletedFeatureIds() {
  return {
    type: CLEAR_DELETED_FEATURE_IDS
  };
}