"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementAppWrapper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _public = require("@kbn/core/public");
var _sharedUxErrorBoundary = require("@kbn/shared-ux-error-boundary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ManagementAppWrapper extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "unmount", void 0);
    (0, _defineProperty2.default)(this, "mountElementRef", /*#__PURE__*/(0, _react.createRef)());
    this.state = {
      error: null
    };
  }
  componentDidMount() {
    const {
      setBreadcrumbs,
      app,
      onAppMounted,
      history,
      theme
    } = this.props;
    const {
      mount,
      basePath
    } = app;
    const appHistory = history.createSubHistory(app.basePath);

    // TODO: Remove this: it provides a deprecated field still needed in ManagementAppMountParams
    const {
      theme$
    } = theme;
    const mountResult = mount({
      basePath,
      setBreadcrumbs: crumbs => setBreadcrumbs(crumbs, appHistory),
      element: this.mountElementRef.current,
      history: appHistory,
      theme,
      theme$
    });
    onAppMounted(app.id);
    if (mountResult instanceof Promise) {
      mountResult.then(um => {
        this.unmount = um;
      }).catch(error => {
        this.setState(() => ({
          error
        }));
      });
    } else {
      this.unmount = mountResult;
    }
  }
  async componentWillUnmount() {
    if (this.unmount) {
      await this.unmount();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxErrorBoundary.ThrowIfError, {
      error: this.state.error
    }), /*#__PURE__*/_react.default.createElement("div", {
      // The following classes are a stop-gap for this element that wraps children of KibanaPageTemplate
      className: (0, _classnames.default)('euiPageContentBody', _public.APP_WRAPPER_CLASS),
      ref: this.mountElementRef
    }));
  }
}
exports.ManagementAppWrapper = ManagementAppWrapper;