"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormLabelWithIconTip = FormLabelWithIconTip;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FormLabelWithIconTip({
  formRowLabelText,
  formRowTooltipText
}) {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("span", null, formRowLabelText), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: formRowTooltipText,
    size: "s",
    type: "question"
  }));
}
FormLabelWithIconTip.propTypes = {
  formRowLabelText: _propTypes.default.string.isRequired,
  formRowTooltipText: _propTypes.default.string.isRequired
};