"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _column_header_truncate_container = _interopRequireDefault(require("@kbn/unified-data-table/src/components/column_header_truncate_container"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TooltipButton = ({
  children,
  popoverTitle,
  displayText,
  headerRowHeight,
  iconType = 'questionInCircle'
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const leaveTimer = (0, _react.useRef)(null);
  const clearTimer = (0, _react.useMemo)(() => () => {
    if (leaveTimer.current) {
      clearTimeout(leaveTimer.current);
    }
  }, []);
  const onMouseEnter = (0, _react.useCallback)(() => {
    clearTimer();
    setIsPopoverOpen(true);
  }, [clearTimer]);
  const onMouseLeave = (0, _react.useCallback)(() => {
    leaveTimer.current = setTimeout(() => setIsPopoverOpen(false), 100);
  }, []);
  (0, _react.useEffect)(() => {
    return () => {
      clearTimer();
    };
  }, [clearTimer]);
  return /*#__PURE__*/_react.default.createElement(_column_header_truncate_container.default, {
    headerRowHeight: headerRowHeight
  }, displayText, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      onMouseEnter: onMouseEnter,
      onMouseLeave: onMouseLeave,
      onFocus: onMouseEnter,
      onBlur: onMouseLeave,
      type: iconType,
      tabIndex: 0
    }),
    isOpen: isPopoverOpen,
    anchorPosition: "upCenter",
    panelPaddingSize: "s",
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, popoverTitle), children));
};
exports.TooltipButton = TooltipButton;