"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceSelector = DataSourceSelector;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _react = _interopRequireWildcard(require("react"));
var _use_intersection_ref = require("../../hooks/use_intersection_ref");
var _get_data_view_test_subj = require("../../utils/get_data_view_test_subj");
var _constants = require("./constants");
var _use_data_source_selector = require("./state_machine/use_data_source_selector");
var _selector_popover = require("./sub_components/selector_popover");
var _data_view_menu_item = require("./sub_components/data_view_menu_item");
var _search_controls = require("./sub_components/search_controls");
var _selector_footer = require("./sub_components/selector_footer");
var _utils = require("./utils");
var _add_data_button = require("./sub_components/add_data_button");
var _data_view_filter = require("./sub_components/data_view_filter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataSourceSelector({
  datasets,
  dataSourceSelection,
  allSelection,
  datasetsError,
  dataViews,
  dataViewCount,
  dataViewsError,
  discoverEsqlUrlProps,
  integrations,
  integrationsError,
  isDataViewAllowed,
  isDataViewAvailable,
  isEsqlEnabled,
  isLoadingDataViews,
  isLoadingIntegrations,
  isLoadingUncategorized,
  isSearchingIntegrations,
  onDataViewsReload,
  onDataViewsSearch,
  onDataViewsFilter,
  onDataViewsSort,
  onDataViewsTabClick,
  onIntegrationsLoadMore,
  onIntegrationsReload,
  onIntegrationsSearch,
  onIntegrationsSort,
  onIntegrationsStreamsSearch,
  onIntegrationsStreamsSort,
  onSelectionChange,
  onUncategorizedReload,
  onUncategorizedSearch,
  onUncategorizedSort,
  onUncategorizedTabClick
}) {
  const {
    panelId,
    search,
    dataViewsFilter,
    tabId,
    isOpen,
    isAllMode,
    changePanel,
    closePopover,
    scrollToIntegrationsBottom,
    searchByName,
    filterByType,
    selectAllLogs,
    selectDataset,
    selectDataView,
    sortByOrder,
    switchToIntegrationsTab,
    switchToUncategorizedTab,
    switchToDataViewsTab,
    togglePopover
  } = (0, _use_data_source_selector.useDataSourceSelector)({
    initialContext: {
      selection: dataSourceSelection,
      allSelection
    },
    onDataViewsSearch,
    onDataViewsFilter,
    onDataViewsSort,
    onIntegrationsLoadMore,
    onIntegrationsReload,
    onIntegrationsSearch,
    onIntegrationsSort,
    onIntegrationsStreamsSearch,
    onIntegrationsStreamsSort,
    onUncategorizedSearch,
    onUncategorizedSort,
    onUncategorizedReload,
    onSelectionChange
  });
  const [setSpyRef] = (0, _use_intersection_ref.useIntersectionRef)({
    onIntersecting: scrollToIntegrationsBottom
  });
  const {
    items: integrationItems,
    panels: integrationPanels
  } = (0, _react.useMemo)(() => {
    if (!integrations || integrations.length === 0) {
      return {
        items: [(0, _utils.createIntegrationStatusItem)({
          data: integrations,
          error: integrationsError,
          isLoading: isLoadingIntegrations,
          onRetry: onIntegrationsReload
        })],
        panels: []
      };
    }
    return (0, _utils.buildIntegrationsTree)({
      integrations,
      onDatasetSelected: selectDataset,
      spyRef: setSpyRef
    });
  }, [integrations, integrationsError, isLoadingIntegrations, selectDataset, onIntegrationsReload, setSpyRef]);
  const uncategorizedItems = (0, _react.useMemo)(() => {
    if (!datasets || datasets.length === 0) {
      return [(0, _utils.createUncategorizedStatusItem)({
        data: datasets,
        error: datasetsError,
        isLoading: isLoadingUncategorized,
        onRetry: onUncategorizedReload
      })];
    }
    return datasets.map(dataset => ({
      name: dataset.title,
      onClick: () => selectDataset(dataset)
    }));
  }, [datasets, datasetsError, isLoadingUncategorized, selectDataset, onUncategorizedReload]);
  const dataViewsItems = (0, _react.useMemo)(() => {
    if (!dataViews || dataViews.length === 0) {
      return [(0, _utils.createDataViewsStatusItem)({
        data: dataViews,
        error: dataViewsError,
        isLoading: isLoadingDataViews,
        onRetry: onDataViewsReload
      })];
    }
    return dataViews.map(dataView => ({
      'data-test-subj': (0, _get_data_view_test_subj.getDataViewTestSubj)(dataView.title),
      name: /*#__PURE__*/_react.default.createElement(_data_view_menu_item.DataViewMenuItem, {
        dataView: dataView,
        isAvailable: isDataViewAllowed(dataView)
      }),
      onClick: () => selectDataView(dataView),
      disabled: !isDataViewAvailable(dataView)
    }));
  }, [dataViews, dataViewsError, isDataViewAllowed, isDataViewAvailable, isLoadingDataViews, onDataViewsReload, selectDataView]);
  const tabs = [{
    id: _constants.INTEGRATIONS_TAB_ID,
    name: _constants.integrationsLabel,
    onClick: switchToIntegrationsTab,
    'data-test-subj': 'dataSourceSelectorIntegrationsTab'
  }, {
    id: _constants.UNCATEGORIZED_TAB_ID,
    name: _constants.uncategorizedLabel,
    onClick: () => {
      onUncategorizedTabClick(); // Lazy-load uncategorized datasets only when accessing the Uncategorized tab
      switchToUncategorizedTab();
    },
    'data-test-subj': 'dataSourceSelectorUncategorizedTab'
  }, {
    id: _constants.DATA_VIEWS_TAB_ID,
    name: _constants.dataViewsLabel,
    onClick: () => {
      onDataViewsTabClick(); // Lazy-load data views only when accessing the Data Views tab
      switchToDataViewsTab();
    },
    'data-test-subj': 'dataSourceSelectorDataViewsTab'
  }];
  const tabEntries = tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    onClick: tab.onClick,
    isSelected: tab.id === tabId,
    "data-test-subj": tab['data-test-subj']
  }, tab.name));
  return /*#__PURE__*/_react.default.createElement(_selector_popover.SelectorPopover, {
    selection: dataSourceSelection,
    isOpen: isOpen,
    closePopover: closePopover,
    onClick: togglePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(Tabs, {
    bottomBorder: false
  }, tabEntries), (tabId === _constants.INTEGRATIONS_TAB_ID || tabId === _constants.UNCATEGORIZED_TAB_ID) && /*#__PURE__*/_react.default.createElement(_add_data_button.AddDataButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_search_controls.SearchControls, {
    key: panelId,
    search: search,
    onSearch: searchByName,
    onSort: sortByOrder,
    isLoading: isSearchingIntegrations || isLoadingUncategorized,
    filterComponent: tabId === _constants.DATA_VIEWS_TAB_ID && /*#__PURE__*/_react.default.createElement(_data_view_filter.DataViewsFilter, {
      filter: dataViewsFilter,
      count: dataViewCount,
      onFilter: filterByType
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(ContextMenu, {
    hidden: tabId !== _constants.INTEGRATIONS_TAB_ID,
    initialPanelId: panelId,
    panels: [{
      id: _constants.INTEGRATIONS_PANEL_ID,
      title: _constants.integrationsLabel,
      width: _constants.DATA_SOURCE_SELECTOR_WIDTH,
      items: integrationItems
    }, ...integrationPanels],
    onPanelChange: changePanel,
    className: "eui-yScroll",
    "data-test-subj": "integrationsContextMenu",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ContextMenu, {
    hidden: tabId !== _constants.UNCATEGORIZED_TAB_ID,
    initialPanelId: _constants.UNCATEGORIZED_PANEL_ID,
    panels: [{
      id: _constants.UNCATEGORIZED_PANEL_ID,
      title: _constants.uncategorizedLabel,
      width: _constants.DATA_SOURCE_SELECTOR_WIDTH,
      items: uncategorizedItems
    }],
    className: "eui-yScroll",
    "data-test-subj": "uncategorizedContextMenu",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(ContextMenu, {
    hidden: tabId !== _constants.DATA_VIEWS_TAB_ID,
    initialPanelId: _constants.DATA_VIEWS_PANEL_ID,
    panels: [{
      id: _constants.DATA_VIEWS_PANEL_ID,
      width: _constants.DATA_SOURCE_SELECTOR_WIDTH,
      items: dataViewsItems
    }],
    className: "eui-yScroll",
    "data-test-subj": "dataViewsContextMenu",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_selector_footer.SelectorFooter, null, /*#__PURE__*/_react.default.createElement(_selector_footer.ShowAllLogsButton, {
    isSelected: isAllMode,
    onClick: selectAllLogs,
    allSelection: allSelection
  }), isEsqlEnabled && /*#__PURE__*/_react.default.createElement(_selector_footer.ESQLButton, discoverEsqlUrlProps)));
}
const Tabs = (0, _styled.default)(_eui.EuiTabs)`
  padding: 0 8px;
`;
const ContextMenu = (0, _styled.default)(_eui.EuiContextMenu)`
  max-height: 440px;
  transition: none !important;
`;