"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadAnnotationLibraryFlyout = LoadAnnotationLibraryFlyout;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _flyout_container = require("../../shared_components/flyout_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LoadAnnotationLibraryFlyout({
  eventAnnotationService,
  isLoadLibraryVisible,
  setLoadLibraryFlyoutVisible,
  addLayer,
  isInlineEditing
}) {
  const {
    renderEventAnnotationGroupSavedObjectFinder: EventAnnotationGroupSavedObjectFinder,
    loadAnnotationGroup
  } = eventAnnotationService || {};
  return /*#__PURE__*/_react.default.createElement(_flyout_container.FlyoutContainer, {
    customFooter: /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      className: "lnsDimensionContainer__footer"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "spaceBetween"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      size: "s",
      iconType: "cross",
      onClick: () => {
        setLoadLibraryFlyoutVisible(false);
      },
      "data-test-subj": "lns-indexPattern-loadLibraryCancel"
    }, _i18n.i18n.translate('xpack.lens.loadAnnotationsLibrary.cancel', {
      defaultMessage: 'Cancel'
    }))))),
    isOpen: Boolean(isLoadLibraryVisible),
    label: _i18n.i18n.translate('xpack.lens.editorFrame.loadFromLibrary', {
      defaultMessage: 'Select annotations from library'
    }),
    handleClose: () => {
      setLoadLibraryFlyoutVisible(false);
    },
    isInlineEditing: isInlineEditing
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          padding: ${_uiTheme.euiThemeVars.euiSize};
          height: 100%;
        `
  }, /*#__PURE__*/_react.default.createElement(EventAnnotationGroupSavedObjectFinder, {
    onChoose: ({
      id
    }) => {
      loadAnnotationGroup(id).then(loadedGroup => {
        addLayer({
          ...loadedGroup,
          annotationGroupId: id
        });
        setLoadLibraryFlyoutVisible(false);
      });
    },
    onCreateNew: () => {
      addLayer();
      setLoadLibraryFlyoutVisible(false);
    }
  })));
}