"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultPercentagePaletteParams = exports.defaultNumberPaletteParams = exports.RANGE_MIN = void 0;
var _shared_components = require("../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RANGE_MIN = exports.RANGE_MIN = 0;
const defaultPercentagePaletteParams = exports.defaultPercentagePaletteParams = {
  ..._shared_components.defaultPaletteParams,
  name: 'status',
  rangeType: 'percent',
  steps: 3,
  maxSteps: 5,
  continuity: 'all',
  colorStops: [],
  stops: []
};
const defaultNumberPaletteParams = exports.defaultNumberPaletteParams = {
  ..._shared_components.defaultPaletteParams,
  name: 'status',
  rangeType: 'number',
  rangeMin: -Infinity,
  rangeMax: Infinity,
  steps: 3,
  maxSteps: 5,
  continuity: 'all',
  colorStops: [],
  stops: []
};