"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisLabel = VisLabel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultHeader = _i18n.i18n.translate('xpack.lens.label.header', {
  defaultMessage: 'Label'
});
const MODE_NONE = {
  id: `lns_title_none`,
  value: 'none',
  text: _i18n.i18n.translate('xpack.lens.chart.labelVisibility.none', {
    defaultMessage: 'None'
  })
};
const MODE_CUSTOM = {
  id: `lns_title_custom`,
  value: 'custom',
  text: _i18n.i18n.translate('xpack.lens.chart.labelVisibility.custom', {
    defaultMessage: 'Custom'
  })
};
const MODE_AUTO = {
  id: `lns_title_auto`,
  value: 'auto',
  text: _i18n.i18n.translate('xpack.lens.chart.labelVisibility.auto', {
    defaultMessage: 'Auto'
  })
};
const modeDefaultOptions = [MODE_NONE, MODE_CUSTOM];
const modeEnhancedOptions = [MODE_NONE, MODE_AUTO, MODE_CUSTOM];
function VisLabel({
  label,
  mode,
  handleChange,
  hasAutoOption = false,
  placeholder = '',
  header = defaultHeader,
  dataTestSubj
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": `${dataTestSubj}-select`,
    "aria-label": "Label",
    onChange: ({
      target
    }) => {
      handleChange({
        // reset title to undefined when switching mode
        label: undefined,
        mode: target.value
      });
    },
    options: hasAutoOption ? modeEnhancedOptions : modeDefaultOptions,
    value: mode
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": dataTestSubj,
    compressed: true,
    placeholder: mode === 'none' ? '' : placeholder,
    value: label || '',
    disabled: mode === 'none',
    onChange: ({
      target
    }) => handleChange({
      mode: 'custom',
      label: target.value
    }),
    "aria-label": header
  })));
}