"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCellColorFn = getCellColorFn;
var _coloring = require("@kbn/coloring");
var _color_mapping_accessor = require("./color_mapping_accessor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getCellColorFn(paletteService, palettes, data, colorByTerms, isDarkMode, syncColors, palette, colorMapping) {
  if (!colorByTerms && palette && data.type === 'ranges') {
    return value => {
      var _paletteService$get$g, _paletteService$get$g2, _paletteService$get;
      if (value === null || value === undefined || typeof value !== 'number') return null;
      return (_paletteService$get$g = (_paletteService$get$g2 = (_paletteService$get = paletteService.get(palette.name)).getColorForValue) === null || _paletteService$get$g2 === void 0 ? void 0 : _paletteService$get$g2.call(_paletteService$get, value, palette.params, data)) !== null && _paletteService$get$g !== void 0 ? _paletteService$get$g : null;
    };
  }
  if (colorByTerms && data.type === 'categories') {
    if (colorMapping) {
      return (0, _color_mapping_accessor.getColorAccessorFn)(palettes, colorMapping, data, isDarkMode);
    } else if (palette) {
      return value => {
        var _palette$params;
        if (value === undefined || value === null) return null;
        const key = (0, _coloring.getValueKey)(value);
        return paletteService.get(palette.name).getCategoricalColor([{
          name: (0, _coloring.getSpecialString)(key),
          // needed to sync special categories (i.e. '')
          rankAtDepth: Math.max(data.categories.findIndex(v => v === key), 0),
          totalSeriesAtDepth: data.categories.length || 1
        }], {
          maxDepth: 1,
          totalSeries: data.categories.length || 1,
          behindText: false,
          syncColors
        }, (_palette$params = palette === null || palette === void 0 ? void 0 : palette.params) !== null && _palette$params !== void 0 ? _palette$params : {
          colors: []
        });
      };
    }
  }
  return () => null;
}