"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountInlinePanel = mountInlinePanel;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shared logic to mount the inline config panel
 * @param ConfigPanel
 * @param coreStart
 * @param overlayTracker
 * @param uuid
 * @param container
 */
function mountInlinePanel(InlinePanel, coreStart, overlayTracker, {
  container,
  dataTestSubj,
  uuid
} = {}) {
  const dataTestSubjFinal = dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : 'customizeLens';
  if (container) {
    _reactDom.default.render(InlinePanel, container);
  } else {
    const handle = coreStart.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.cloneElement(InlinePanel, {
      closeFlyout: () => {
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        handle.close();
      }
    }), coreStart), {
      className: 'lnsConfigPanel__overlay',
      css: inlineFlyoutStyles,
      size: 's',
      'data-test-subj': dataTestSubjFinal,
      type: 'push',
      paddingSize: 'm',
      maxWidth: 800,
      hideCloseButton: true,
      isResizable: true,
      onClose: overlayRef => {
        overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.clearOverlays();
        overlayRef.close();
      },
      outsideClickCloses: true
    });
    if (uuid) {
      overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle, {
        focusedPanelId: uuid
      });
    }
  }
}

// styles needed to display extra drop targets that are outside of the config panel main area while also allowing to scroll vertically
const inlineFlyoutStyles = ({
  euiTheme
}) => `
  clip-path: none; // needed to override the eui-flyout clip-path
  max-inline-size: 640px;
  min-inline-size: 256px;
  background:${euiTheme.colors.lightestShade};

  .kbnOverlayMountWrapper {
    padding-left: 400px;
    margin-left: -400px;
    pointer-events: none;
    .euiFlyoutFooter {
      pointer-events: auto;
    }
  }
`;