"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStateManagementForInlineEditing = getStateManagementForInlineEditing;
var _shared_logic = require("../../state_management/shared_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getStateManagementForInlineEditing(activeDatasourceId, getAttributes, updateAttributes, visualizationMap, datasourceMap, extractFilterReferences) {
  const updatePanelState = (datasourceState, visualizationState, visualizationType) => {
    const viz = getAttributes();
    const datasourceStates = {
      [activeDatasourceId]: {
        isLoading: false,
        state: datasourceState
      }
    };
    const newViz = (0, _shared_logic.mergeToNewDoc)(viz, {
      activeId: visualizationType || viz.visualizationType,
      state: visualizationState
    }, datasourceStates, viz.state.query, viz.state.filters, activeDatasourceId, viz.state.adHocDataViews || {}, {
      visualizationMap,
      datasourceMap,
      extractFilterReferences
    });
    const newDoc = {
      ...viz,
      ...newViz
    };
    if (newDoc.state) {
      updateAttributes(newDoc, true);
    }
  };
  const updateSuggestion = updateAttributes;
  return {
    updateSuggestion,
    updatePanelState
  };
}