"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoFieldWorkspacePanel = GeoFieldWorkspacePanel;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _utils = require("../../../utils");
var _constants = require("../../../../common/constants");
var _workspace_panel = require("./workspace_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dragDropIdentifier = {
  id: 'lnsGeoFieldWorkspace',
  humanData: {
    label: _i18n.i18n.translate('xpack.lens.geoFieldWorkspace.dropZoneLabel', {
      defaultMessage: 'drop zone to open in maps'
    })
  }
};
const dragDropOrder = [1, 0, 0, 0];
function GeoFieldWorkspacePanel(props) {
  function onDrop() {
    props.uiActions.getTrigger(_public.VISUALIZE_GEO_FIELD_TRIGGER).exec({
      dataViewSpec: props.indexPattern.spec,
      fieldName: props.fieldName,
      originatingApp: _constants.APP_ID
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-scrollBar",
    css: _workspace_panel.pageContentBodyStyles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement("strong", null, (0, _utils.getVisualizeGeoFieldMessage)(props.fieldType))), /*#__PURE__*/_react.default.createElement(_chartIcons.GlobeIllustration, {
    "aria-hidden": true,
    css: _workspace_panel.promptIllustrationStyle
  }), /*#__PURE__*/_react.default.createElement(_domDragDrop.Droppable, {
    css: droppableStyles,
    dataTestSubj: "lnsGeoFieldWorkspace",
    dropTypes: ['field_add'],
    order: dragDropOrder,
    value: dragDropIdentifier,
    onDrop: onDrop
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.geoFieldWorkspace.dropMessage",
    defaultMessage: "Drop field here to open in Maps"
  })))))));
}
const droppableStyles = ({
  euiTheme
}) => {
  return `
    padding: ${euiTheme.size.xxl} ${euiTheme.size.xxxl};
    border: ${euiTheme.border.thin};
    border-radius: ${euiTheme.border.radius};
  `;
};