"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnReducedTimeRangeError = getColumnReducedTimeRangeError;
exports.reducedTimeRangeOptions = exports.reducedTimeRangeOptionOrder = void 0;
var _i18n = require("@kbn/i18n");
var _user_messages_ids = require("../../user_messages_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reducedTimeRangeOptions = exports.reducedTimeRangeOptions = [{
  label: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.30s', {
    defaultMessage: '30 seconds (30s)'
  }),
  value: '30s'
}, {
  label: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.1m', {
    defaultMessage: '1 minute (1m)'
  }),
  value: '1m'
}, {
  label: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.5m', {
    defaultMessage: '5 minutes (5m)'
  }),
  value: '5m'
}, {
  label: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.15m', {
    defaultMessage: '15 minutes (15m)'
  }),
  value: '15m'
}, {
  label: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRange.1h', {
    defaultMessage: '1 hour (1h)'
  }),
  value: '1h'
}];
const reducedTimeRangeOptionOrder = exports.reducedTimeRangeOptionOrder = reducedTimeRangeOptions.reduce((optionMap, {
  value
}, index) => ({
  ...optionMap,
  [value]: index
}), {});
function getColumnReducedTimeRangeError(layer, columnId, indexPattern) {
  const currentColumn = layer.columns[columnId];
  if (!currentColumn.reducedTimeRange) {
    return [];
  }
  const hasDateHistogram = Object.values(layer.columns).some(column => column.operationType === 'date_histogram');
  const hasTimeField = Boolean(indexPattern.timeFieldName);
  const errors = [];
  if (hasDateHistogram) {
    errors.push({
      uniqueId: _user_messages_ids.REDUCED_TIME_RANGE_NO_DATE_HISTOGRAM,
      message: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRangeWithDateHistogram', {
        defaultMessage: 'Reduced time range can only be used without a date histogram. Either remove the date histogram dimension or remove the reduced time range from {column}.',
        values: {
          column: currentColumn.label
        }
      })
    });
  }
  if (!hasTimeField) {
    errors.push({
      uniqueId: _user_messages_ids.REDUCED_TIME_RANGE_DEFAULT_DATE_FIELD,
      message: _i18n.i18n.translate('xpack.lens.indexPattern.reducedTimeRangeWithoutTimefield', {
        defaultMessage: 'Reduced time range can only be used with a specified default time field on the data view. Either use a different data view with default time field or remove the reduced time range from {column}.',
        values: {
          column: currentColumn.label
        }
      })
    });
  }
  return errors;
}