"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      colors,
      size,
      font,
      border
    } = euiTheme;
    const breadcrumb = {
      borderBottom: border.thin,
      borderColor: colors.lightShade,
      paddingBottom: size.s,
      marginBottom: size.m
    };
    const breadcrumbButton = {
      height: 'fit-content',
      maxWidth: '248px',
      fontSize: size.m,
      fontWeight: font.weight.regular,
      '.euiButtonEmpty': {
        paddingInline: size.xs
      }
    };
    const breadcrumbButtonBold = {
      ...breadcrumbButton,
      fontWeight: font.weight.semiBold
    };
    const breadcrumbRightIcon = {
      marginRight: size.xs
    };
    const breadcrumbsWrapper = {
      flexDirection: 'row',
      alignItems: 'center'
    };
    const breadcrumbIconColor = color => ({
      color
    });
    return {
      breadcrumb,
      breadcrumbButton,
      breadcrumbButtonBold,
      breadcrumbRightIcon,
      breadcrumbsWrapper,
      breadcrumbIconColor
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;