"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPageTemplateSolutionNav = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./solution_nav.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _solution_nav_avatar = require("./solution_nav_avatar");
var _solution_nav_collapse_button = require("./solution_nav_collapse_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const setTabIndex = (items, isHidden) => {
  return items.map(item => {
    // @ts-ignore-next-line Can be removed on close of https://github.com/elastic/eui/issues/4925
    item.tabIndex = isHidden ? -1 : undefined;
    item.items = item.items && setTabIndex(item.items, isHidden);
    return item;
  });
};

/**
 * A wrapper around EuiSideNav but also creates the appropriate title with optional solution logo
 */
const KibanaPageTemplateSolutionNav = ({
  name,
  icon,
  items,
  isOpenOnDesktop = false,
  onCollapse,
  ...rest
}) => {
  // The EuiShowFor and EuiHideFor components are not in sync with the euiBreakpoint() function :(
  const isSmallerBreakpoint = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const isMediumBreakpoint = (0, _eui.useIsWithinBreakpoints)(['m']);
  const isLargerBreakpoint = (0, _eui.useIsWithinBreakpoints)(['l', 'xl']);

  // This is used for both the EuiSideNav and EuiFlyout toggling
  const [isSideNavOpenOnMobile, setIsSideNavOpenOnMobile] = (0, _react.useState)(false);
  const toggleOpenOnMobile = () => {
    setIsSideNavOpenOnMobile(!isSideNavOpenOnMobile);
  };
  const isHidden = isLargerBreakpoint && !isOpenOnDesktop;

  /**
   * Create the avatar
   */
  let solutionAvatar;
  if (icon) {
    solutionAvatar = /*#__PURE__*/_react.default.createElement(_solution_nav_avatar.KibanaPageTemplateSolutionNavAvatar, {
      iconType: icon,
      name: name
    });
  }

  /**
   * Create the titles
   */
  const titleText = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, solutionAvatar, /*#__PURE__*/_react.default.createElement("strong", null, name));
  const mobileTitleText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "kibana-react.solutionNav.mobileTitleText",
    defaultMessage: "{solutionName} Menu",
    values: {
      solutionName: name || 'Navigation'
    }
  });

  /**
   * Create the side nav component
   */
  let sideNav;
  if (items) {
    const sideNavClasses = (0, _classnames.default)('kbnPageTemplateSolutionNav', {
      'kbnPageTemplateSolutionNav--hidden': isHidden
    });
    sideNav = /*#__PURE__*/_react.default.createElement(_eui.EuiSideNav, (0, _extends2.default)({
      "aria-hidden": isHidden,
      className: sideNavClasses,
      heading: titleText,
      mobileTitle: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, solutionAvatar, mobileTitleText),
      toggleOpenOnMobile: toggleOpenOnMobile,
      isOpenOnMobile: isSideNavOpenOnMobile,
      items: setTabIndex(items, isHidden)
    }, rest));
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isSmallerBreakpoint && sideNav, isMediumBreakpoint && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isSideNavOpenOnMobile && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: false,
    outsideClickCloses: true,
    onClose: () => setIsSideNavOpenOnMobile(false),
    side: "left",
    size: 248,
    closeButtonPosition: "outside",
    className: "kbnPageTemplateSolutionNav__flyout"
  }, sideNav), /*#__PURE__*/_react.default.createElement(_solution_nav_collapse_button.KibanaPageTemplateSolutionNavCollapseButton, {
    isCollapsed: true,
    onClick: toggleOpenOnMobile
  })), isLargerBreakpoint && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, sideNav, /*#__PURE__*/_react.default.createElement(_solution_nav_collapse_button.KibanaPageTemplateSolutionNavCollapseButton, {
    isCollapsed: !isOpenOnDesktop,
    onClick: onCollapse
  })));
};
exports.KibanaPageTemplateSolutionNav = KibanaPageTemplateSolutionNav;