"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const contentCss = (0, _react2.css)`
  width: 100%;
  max-width: 730px;
`;
const StepContentWrapper = exports.StepContentWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  title,
  subtitle,
  right
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  css: contentCss
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "row",
  justifyContent: "spaceBetween",
  alignItems: "flexEnd"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  alignItems: "flexStart",
  justifyContent: "flexStart",
  gutterSize: "xs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h1", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  color: "subdued"
}, subtitle)))), right && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, right)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), children))));
StepContentWrapper.displayName = 'StepContentWrapper';